/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.abfs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.hadoop.util.JsonSerialization;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize
public class AbfsAuthResponseMessage {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_in")
    private Integer expiresIn;
    @JsonProperty(value="expires_on")
    private Long expiresOn;
    @JsonProperty(value="resource")
    private String resource;
    @JsonProperty(value="token_type")
    private String tokenType;

    public static JsonSerialization<AbfsAuthResponseMessage> serializer() {
        return new JsonSerialization(AbfsAuthResponseMessage.class, false, true);
    }

    public Instant getExpiry() {
        Instant instant = this.expiresOn != null ? Instant.ofEpochSecond(this.expiresOn) : (this.expiresIn != null ? Instant.now().plus((long)this.expiresIn.intValue(), ChronoUnit.SECONDS) : Instant.now());
        return instant;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public Long getExpiresOn() {
        return this.expiresOn;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getResource() {
        return this.resource;
    }
}

