/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.abfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.fs.azurebfs.extensions.CustomDelegationTokenManager;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBIntegration;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.common.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsIDBDelegationTokenManager
implements CustomDelegationTokenManager,
BoundDTExtension {
    protected static final Logger LOG = LoggerFactory.getLogger(AbfsIDBDelegationTokenManager.class);
    public static final String NAME = "org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBDelegationTokenManager";
    private AbfsIDBIntegration integration;

    public void initialize(Configuration configuration) throws IOException {
    }

    public void bind(URI uri, Configuration conf) throws IOException {
        LOG.debug("Binding to URI {}", (Object)uri);
        this.setIntegration(AbfsIDBIntegration.fromDelegationTokenManager(uri, conf));
    }

    public void close() throws IOException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.integration});
    }

    private void checkBound() {
        Preconditions.checkState(this.integration != null, "Credential Provider is not bound");
    }

    public String getCanonicalServiceName() {
        this.checkBound();
        return this.integration.getCanonicalServiceName();
    }

    public String getUserAgentSuffix() {
        return "";
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        this.checkBound();
        Token<AbfsIDBTokenIdentifier> token = this.integration.getDelegationToken(renewer);
        return token;
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        return 0L;
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
    }

    protected void setIntegration(AbfsIDBIntegration integration) throws IOException {
        this.integration = integration;
    }
}

