/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.abfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsAuthResponseMessage;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBClient;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBIntegration;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbfsTestIDBIntegration
extends AbfsIDBIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsTestIDBIntegration.class);
    private final Path testTokenPath;
    private boolean getTestToken;
    private AzureADToken testToken;
    private AbfsIDBClient testClient;

    static AbfsTestIDBIntegration fromDelegationTokenManager(URI fsUri, Configuration conf) throws IOException {
        AbfsTestIDBIntegration integration = new AbfsTestIDBIntegration(fsUri, conf, "DelegationTokenManager");
        integration.init(conf);
        integration.start();
        return integration;
    }

    static AbfsTestIDBIntegration fromAbfsCredentialProvider(URI fsUri, Configuration conf) throws IOException {
        AbfsTestIDBIntegration integration = new AbfsTestIDBIntegration(fsUri, conf, "CredentialProvider");
        integration.init(conf);
        integration.start();
        return integration;
    }

    AbfsTestIDBIntegration(@Nonnull URI fsUri, @Nonnull Configuration configuration, @Nonnull String origin) throws IOException {
        this(fsUri, configuration, origin, null);
    }

    AbfsTestIDBIntegration(@Nonnull URI fsUri, @Nonnull Configuration configuration, @Nonnull String origin, AbfsIDBClient client) throws IOException {
        super("AbfsTestIDBIntegration", fsUri, configuration, origin);
        String propertyValue;
        LOG.warn("This implementation of the AbfsIDBIntegration is for testing purposes only");
        if (client != null) {
            this.testClient = client;
        }
        if (StringUtils.isNotEmpty((CharSequence)(propertyValue = configuration.getTrimmed(AbfsIDBProperty.IDBROKER_TEST_TOKEN_PATH.getPropertyName())))) {
            Path path = Paths.get(propertyValue, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.warn("The specified path does not exist, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isRegularFile(path, new LinkOption[0])) {
                LOG.warn("The specified path is not a file, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isReadable(path)) {
                LOG.warn("The specified file is not readable, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else {
                this.testTokenPath = path;
                LOG.warn("Using test access token from {}", (Object)this.testTokenPath.toAbsolutePath());
            }
        } else {
            LOG.warn("A file for a test token was not specified, a test token will not be used");
            this.testTokenPath = null;
        }
        this.getTestToken = this.testTokenPath != null;
    }

    @Override
    protected AbfsIDBClient getClient() throws IOException {
        return this.testClient != null ? this.testClient : super.getClient();
    }

    @Override
    AzureADToken getADToken(boolean renewIfNeeded) throws IOException {
        AzureADToken token;
        if (this.getTestToken) {
            this.testToken = this.readTestToken();
        }
        if (renewIfNeeded) {
            if (this.getTestToken) {
                this.getTestToken = false;
            } else {
                this.testToken = null;
            }
        }
        if ((token = this.testToken) == null) {
            LOG.warn("This implementation of the AbfsIDBIntegration is for testing purposes only - using REAL access token");
            return super.getADToken(renewIfNeeded);
        }
        LOG.warn("This implementation of the AbfsIDBIntegration is for testing purposes only - using TEST access token");
        return token;
    }

    private AzureADToken readTestToken() throws IOException {
        AbfsAuthResponseMessage responseMessage;
        if (this.testTokenPath != null) {
            try (InputStream inputStream = Files.newInputStream(this.testTokenPath, new OpenOption[0]);){
                responseMessage = (AbfsAuthResponseMessage)AbfsAuthResponseMessage.serializer().fromJsonStream(inputStream);
            }
        } else {
            responseMessage = null;
        }
        if (responseMessage != null) {
            AzureADToken testToken = new AzureADToken();
            testToken.setAccessToken(responseMessage.getAccessToken());
            testToken.setExpiry(Date.from(responseMessage.getExpiry()));
            return testToken;
        }
        return null;
    }
}

