/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class CommonUtils {
    public static boolean useCABCertFromDelegationToken(Configuration conf, String prefix) {
        return conf.getBoolean(prefix + "use.dt.cert", false);
    }

    public static String getTruststoreLocation(Configuration conf, String propertyName) {
        return CommonUtils.getTruststoreLocation(conf, propertyName, null);
    }

    public static String getTruststoreLocation(Configuration conf, String propertyName, String defaultValue) {
        String result = conf.getTrimmed(propertyName);
        if (StringUtils.isBlank((CharSequence)result)) {
            CommonUtils.ensureSSLClientConfigLoaded(conf);
            result = conf.getTrimmed("ssl.client.truststore.location");
            if (StringUtils.isBlank((CharSequence)result)) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static String getTruststorePass(Configuration conf, String propertyName) {
        return CommonUtils.getTruststorePass(conf, propertyName, null);
    }

    public static String getTruststorePass(Configuration conf, String propertyName, String defaultValue) {
        String result = CommonUtils.getPassword(conf, propertyName);
        if (StringUtils.isBlank((CharSequence)result)) {
            CommonUtils.ensureSSLClientConfigLoaded(conf);
            result = CommonUtils.getPassword(conf, "ssl.client.truststore.password");
            if (StringUtils.isBlank((CharSequence)result)) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static String getPassword(Configuration conf, String key) {
        String result = null;
        try {
            char[] secret = conf.getPassword(key);
            if (secret != null && secret.length > 0) {
                result = new String(secret);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void ensureSSLClientConfigLoaded(Configuration conf) {
        String sslClientConfigLocation = conf.getTrimmed("hadoop.ssl.client.conf");
        if (!StringUtils.isBlank((CharSequence)sslClientConfigLocation)) {
            conf.addResource(sslClientConfigLocation);
        }
    }
}

