/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.knox.gateway.cloud.idbroker.common.EndpointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointManager
implements EndpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEndpointManager.class);
    private static final String ERROR_NULL_ENDPOINT = "IDBroker configuration for the endpoints for accessing tokens is missing. This will adversely affect the ability to acquire, renew and cancel tokens.";
    private ConcurrentLinkedQueue<String> endpoints = new ConcurrentLinkedQueue();

    protected DefaultEndpointManager() {
    }

    public DefaultEndpointManager(List<String> endpoints) {
        this.setURLs(endpoints);
    }

    @Override
    public synchronized String getActiveURL() {
        return this.endpoints.peek();
    }

    protected synchronized void setActiveURL(String url) {
        String top = this.endpoints.peek();
        if (top != null && top.equalsIgnoreCase(url)) {
            return;
        }
        if (this.endpoints.contains(url)) {
            this.endpoints.remove(url);
            List<String> remainingList = this.getURLs();
            this.endpoints.clear();
            this.endpoints.add(url);
            this.endpoints.addAll(remainingList);
        }
    }

    @Override
    public synchronized List<String> getURLs() {
        return new ArrayList<String>(this.endpoints);
    }

    protected synchronized void setURLs(List<String> endpoints) {
        if (endpoints != null && !endpoints.isEmpty()) {
            this.endpoints.clear();
            for (String endpoint : endpoints) {
                if (endpoint == null) {
                    LOG.error(ERROR_NULL_ENDPOINT);
                    continue;
                }
                this.endpoints.add(endpoint.trim());
            }
        }
    }

    @Override
    public synchronized void markFailed(String url) {
        String top = this.endpoints.peek();
        if (top != null) {
            String incomingHostPort;
            boolean pushToBottom = false;
            URI topUri = URI.create(top);
            URI incomingUri = URI.create(url);
            String topHostPort = topUri.getHost() + ":" + topUri.getPort();
            if (topHostPort.equals(incomingHostPort = incomingUri.getHost() + ":" + incomingUri.getPort())) {
                pushToBottom = true;
            }
            if (pushToBottom) {
                String failed = this.endpoints.poll();
                this.endpoints.offer(failed);
                LOG.error("Failed endpoint {}; Failing over to {} ...", (Object)failed, (Object)this.endpoints.peek());
            }
        }
    }
}

