/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Range;

public class RequestErrorHandlingAttributes {
    private static final Range<Integer> VALID_FAILOVER_ATTEMPT_RANGE = Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(10));
    private static final Range<Integer> VALID_FAILOVER_SLEEP_RANGE = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5));
    private static final Range<Integer> VALID_RETRY_ATTEMPT_RANGE = Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(10));
    private static final Range<Integer> VALID_RETRY_SLEEP_RANGE = Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10));
    private static final String ERROR_MSG_TEMPLATE = "%s = %d is not in %s";
    private final int maxFailoverAttempts;
    private final int failoverSleep;
    private final int maxRetryAttempts;
    private final int retrySleep;

    public RequestErrorHandlingAttributes(int maxFailoverAttempts, int failoverSleep, int maxRetryAttempts, int retrySleep) {
        this.maxFailoverAttempts = maxFailoverAttempts;
        this.failoverSleep = failoverSleep;
        this.maxRetryAttempts = maxRetryAttempts;
        this.retrySleep = retrySleep;
        this.validate();
    }

    private void validate() {
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        this.check(this.maxFailoverAttempts, VALID_FAILOVER_ATTEMPT_RANGE, "maxFailoverAttempts", errors);
        this.check(this.failoverSleep, VALID_FAILOVER_SLEEP_RANGE, "failoverSleep", errors);
        this.check(this.maxRetryAttempts, VALID_RETRY_ATTEMPT_RANGE, "maxRetryAttempts", errors);
        this.check(this.retrySleep, VALID_RETRY_SLEEP_RANGE, "retrySleep", errors);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException("Found validation error(s): " + String.join((CharSequence)"; ", errors));
        }
    }

    private void check(int value, Range<Integer> range, String attributeName, Set<String> errors) {
        if (!range.contains((Object)value)) {
            errors.add(String.format(Locale.ROOT, ERROR_MSG_TEMPLATE, attributeName, value, range.toString()));
        }
    }

    public int getMaxFailoverAttempts() {
        return this.maxFailoverAttempts;
    }

    public long getFailoverSleepInMillis() {
        return TimeUnit.SECONDS.toMillis(this.failoverSleep);
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public long getRetrySleepInMillis() {
        return TimeUnit.SECONDS.toMillis(this.retrySleep);
    }
}

