/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.google.cloud.hadoop.fs.gcs.auth.AbstractDelegationTokenBinding;
import com.google.cloud.hadoop.fs.gcs.auth.DelegationTokenIOException;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.IDBClient;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxTokenMonitor;
import org.apache.knox.gateway.cloud.idbroker.common.UTCClock;
import org.apache.knox.gateway.cloud.idbroker.google.CABGCPTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.google.CABUtils;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerBindingConstants;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerTokenProvider;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBProperty;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleTempCredentials;
import org.apache.knox.gateway.cloud.idbroker.google.TokenProvider;
import org.apache.knox.gateway.cloud.idbroker.messages.RequestDTResponseMessage;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.util.Tokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CABDelegationTokenBinding
extends AbstractDelegationTokenBinding {
    protected static final Logger LOG = LoggerFactory.getLogger(CABDelegationTokenBinding.class);
    static final String E_INVALID_DT_RESPONSE = "Invalid delegation token response";
    static final String E_FAILED_DT_SESSION = "Error establishing session with delegation token provider";
    static final String E_FAILED_CLOUD_SESSION = "Error establishing session with Cloud Access Broker credential provider";
    static final String E_NO_SESSION_TO_KNOX_CREDS = "No session with Knox credential endpoint";
    static final String E_MISSING_DT_USERNAME_CONFIG = "Missing Cloud Access Broker delegation token username configuration in fs.gs.ext.cab.username";
    protected IDBClient<AccessTokenProvider.AccessToken> cabClient;
    private KnoxToken knoxToken;
    private KnoxTokenMonitor knoxTokenMonitor;
    private final Lock lock = new ReentrantLock(true);
    private GoogleTempCredentials marshalledCredentials;
    private TokenProvider accessTokenProvider;

    public CABDelegationTokenBinding() {
        super("IDBDelegationTokenBinding", CloudAccessBrokerBindingConstants.CAB_TOKEN_KIND);
    }

    private void initKnoxTokenMonitor() {
        IDBClient<AccessTokenProvider.AccessToken> client;
        if (this.knoxTokenMonitor == null && (client = this.getClient()) != null && client.shouldInitKnoxTokenMonitor()) {
            this.knoxTokenMonitor = new KnoxTokenMonitor();
        }
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopKnoxTokenMonitor();
        super.serviceStop();
    }

    private void stopKnoxTokenMonitor() {
        if (this.knoxTokenMonitor != null) {
            this.knoxTokenMonitor.shutdown();
        }
    }

    IDBClient<AccessTokenProvider.AccessToken> getClient() {
        this.lock.lock();
        try {
            if (this.cabClient == null) {
                try {
                    this.cabClient = CABUtils.newClient(this.getConf(), UserGroupInformation.getCurrentUser());
                    if (this.cabClient == null) {
                        LOG.error("cabClient has not been initialized.");
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error creating new IDBroker client for Google Cloud Platform.", t);
                }
            }
            IDBClient<AccessTokenProvider.AccessToken> iDBClient = this.cabClient;
            return iDBClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    Configuration getConf() {
        return this.getFileSystem().getConf();
    }

    public AccessTokenProvider deployUnbonded() throws IOException {
        this.lock.lock();
        try {
            this.maybeRenewAccessToken();
            TokenProvider tokenProvider = this.getAccessTokenProvider();
            return tokenProvider;
        }
        finally {
            this.lock.unlock();
        }
    }

    TokenProvider getAccessTokenProvider() {
        if (this.accessTokenProvider == null) {
            LOG.debug("No existing accessTokenProvider");
            String gcpToken = null;
            long gcpTokenExp = -1L;
            if (this.marshalledCredentials != null) {
                LOG.debug("Using existing marshalled credentials");
                gcpToken = this.marshalledCredentials.getToken();
                gcpTokenExp = this.marshalledCredentials.getExpiration();
            }
            LOG.debug("Creating new accessTokenProvider");
            this.accessTokenProvider = new CloudAccessBrokerTokenProvider(this.getClient(), this.knoxToken, gcpToken, gcpTokenExp);
        }
        return this.accessTokenProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegationTokenIdentifier createTokenIdentifier(Text renewer) throws IOException {
        this.lock.lock();
        try {
            String tokenType = null;
            String targetURL = CABUtils.getCloudAccessBrokerURL(this.getConf(), this.getClient().getGatewayAddress());
            this.maybeRenewAccessToken();
            String knoxDT = this.knoxToken == null ? "" : this.knoxToken.getAccessToken();
            long expiryTime = this.knoxToken == null ? 0L : this.knoxToken.getExpiry();
            String endpointCertificate = this.knoxToken == null ? "" : this.knoxToken.getEndpointPublicCert();
            boolean managed = this.knoxToken == null ? false : this.knoxToken.isManaged();
            GoogleTempCredentials gcpCredentials = this.getConf().getBoolean("fs.gs.ext.cab.init.credentials", true) ? this.collectGCPCredentials() : new GoogleTempCredentials();
            CABGCPTokenIdentifier identifier = new CABGCPTokenIdentifier(this.getKind(), this.getOwnerText(UserGroupInformation.getCurrentUser()), renewer, this.getCanonicalUri(), knoxDT, expiryTime, tokenType, targetURL, endpointCertificate, gcpCredentials, "Created from " + this.getClient().getGatewayAddress(), managed);
            LOG.info("Created delegation token identifier {}", (Object)identifier);
            CABGCPTokenIdentifier cABGCPTokenIdentifier = identifier;
            return cABGCPTokenIdentifier;
        }
        finally {
            this.lock.unlock();
        }
    }

    public DelegationTokenIdentifier createTokenIdentifier() throws IOException {
        return this.createTokenIdentifier(null);
    }

    public DelegationTokenIdentifier createEmptyIdentifier() {
        return null;
    }

    private void maybeRenewAccessToken() throws IOException {
        if (this.knoxToken == null || StringUtils.isBlank((CharSequence)this.knoxToken.getAccessToken())) {
            if (this.getClient().shouldExcludeUserFromGettingKnoxToken()) {
                LOG.info("'{}' is excluded from getting Knox Token from IDBroker", (Object)this.getClient().getOwnerUserName());
            } else {
                LOG.info("There is no Knox Token available, fetching one from IDBroker...");
                this.getNewKnoxToken();
            }
        } else {
            LOG.info("Using existing Knox Token: " + Tokens.getTokenDisplayText((String)this.knoxToken.getAccessToken()));
        }
    }

    private void getNewKnoxToken() throws IOException {
        Pair<RequestDTResponseMessage, String> message = this.requestDelegationToken();
        if (message != null) {
            this.bondToRequestedToken(message);
        }
    }

    private boolean hasExpired(long seconds) {
        return seconds < TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenProvider bindToTokenIdentifier(DelegationTokenIdentifier retrievedIdentifier) throws IOException {
        this.lock.lock();
        try {
            LOG.info("Binding to retrieved Delegation Token identifier: " + retrievedIdentifier == null ? "N/A" : retrievedIdentifier.toString());
            CABGCPTokenIdentifier tokenIdentifier = (CABGCPTokenIdentifier)this.convertTokenIdentifier(retrievedIdentifier, CABGCPTokenIdentifier.class);
            String endpointCert = tokenIdentifier.getCertificate();
            if (endpointCert != null) {
                LOG.debug("Using Cloud Access Broker public cert from delegation token");
            }
            this.knoxToken = new KnoxToken("origin", tokenIdentifier.getAccessToken(), tokenIdentifier.getTokenType(), tokenIdentifier.getExpiryTime(), endpointCert, tokenIdentifier.isManaged());
            this.monitorKnoxToken();
            this.marshalledCredentials = tokenIdentifier.getMarshalledCredentials();
            LOG.debug("Marshalled GCP credentials: " + this.marshalledCredentials.toString());
            TokenProvider tokenProvider = this.getAccessTokenProvider();
            tokenProvider.updateDelegationToken(this.knoxToken);
            TokenProvider tokenProvider2 = tokenProvider;
            return tokenProvider2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void bondToRequestedToken(Pair<RequestDTResponseMessage, String> response) throws IOException {
        if (response == null || response.getLeft() == null) {
            throw new DelegationTokenIOException(E_INVALID_DT_RESPONSE);
        }
        this.knoxToken = KnoxToken.fromDTResponse((String)response.getRight(), (RequestDTResponseMessage)response.getLeft());
        this.monitorKnoxToken();
        this.getAccessTokenProvider().updateDelegationToken(this.knoxToken);
        LOG.info("Bonded to Knox token {}, expires {}", (Object)this.knoxToken.getPrintableAccessToken(), (Object)UTCClock.secondsToDateTime(this.knoxToken.getExpiry()).map(OffsetDateTime::toString).orElse("undefined"));
        if (this.knoxToken.getEndpointPublicCert() != null) {
            LOG.debug("Including public cert in the delegation token.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<RequestDTResponseMessage, String> requestDelegationToken() throws IOException {
        Pair pair;
        Pair<KnoxSession, String> sessionDetails = this.getDTSession();
        KnoxSession session = (KnoxSession)sessionDetails.getLeft();
        String origin = (String)sessionDetails.getRight();
        try {
            pair = Pair.of((Object)this.getClient().requestKnoxDelegationToken(session, origin, this.getCanonicalUri()), (Object)origin);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
        return pair;
    }

    private GoogleTempCredentials collectGCPCredentials() throws IOException {
        if (this.needsGCPCredentials()) {
            this.marshalledCredentials = this.updateGCPCredentials();
        }
        return this.marshalledCredentials;
    }

    synchronized GoogleTempCredentials updateGCPCredentials() throws IOException {
        GoogleTempCredentials googleTempCredentials;
        CloudAccessBrokerSession session = this.getClient().createKnoxCABSession(this.knoxToken);
        try {
            googleTempCredentials = new GoogleTempCredentials(this.getClient().fetchCloudCredentials(session));
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
        return googleTempCredentials;
    }

    private boolean needsGCPCredentials() {
        boolean isNeeded = true;
        if (this.marshalledCredentials != null && !this.marshalledCredentials.isEmpty()) {
            long expiration = this.marshalledCredentials.getExpiration();
            if (expiration > 0L && this.hasExpired(expiration)) {
                LOG.debug("Expiring current GCP credentials");
                this.resetGCPCredentials();
            } else {
                LOG.debug("Current GCP credentials are still valid");
                isNeeded = false;
            }
        } else {
            LOG.debug("No marshalled GCP credentials");
        }
        return isNeeded;
    }

    private void resetGCPCredentials() {
        this.marshalledCredentials = null;
    }

    private Pair<KnoxSession, String> getDTSession() throws IOException {
        IDBClient<AccessTokenProvider.AccessToken> client = this.getClient();
        LOG.debug("Attempting to create a Knox delegation token session using local credentials (kerberos, simple)");
        Pair<KnoxSession, String> sessionDetails = client.createKnoxDTSession(this.getConf());
        if (sessionDetails.getLeft() != null) {
            LOG.debug("Created a Knox delegation token session using local credentials (kerberos, simple)");
        }
        if (sessionDetails.getLeft() == null) {
            String message = this.knoxToken == null ? "Authentication with IDBroker failed.  Please ensure you have a Kerberos token by using kinit." : "Authentication with IDBroker failed.  The existing Knox delegation token has expired and must be renewed. However, it cannot be renewed unless a valid Kerberos token is available. Please ensure you have a Kerberos token by using kinit.";
            throw new IllegalStateException(message);
        }
        return sessionDetails;
    }

    private Text getOwnerText(UserGroupInformation owner) {
        return new Text(owner.getUserName());
    }

    private URI getCanonicalUri() {
        return this.getFileSystem().getUri();
    }

    private void monitorKnoxToken() {
        this.initKnoxTokenMonitor();
        if (this.knoxTokenMonitor != null) {
            long knoxTokenExpirationOffset = this.getConf().getLong(GoogleIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getPropertyName(), Long.parseLong(GoogleIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getDefaultValue()));
            this.knoxTokenMonitor.monitorKnoxToken(this.knoxToken, knoxTokenExpirationOffset, new GetKnoxTokenCommand());
        }
    }

    private class GetKnoxTokenCommand
    implements KnoxTokenMonitor.GetKnoxTokenCommand {
        private GetKnoxTokenCommand() {
        }

        @Override
        public void execute(KnoxToken knoxToken) throws IOException {
            CABDelegationTokenBinding.this.lock.lock();
            try {
                CABDelegationTokenBinding.this.getNewKnoxToken();
            }
            finally {
                CABDelegationTokenBinding.this.lock.unlock();
            }
        }
    }
}

