/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.google.cloud.hadoop.fs.gcs.auth.DelegationTokenIOException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.common.IDBTokenPayload;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerBindingConstants;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleTempCredentials;

public class CABGCPTokenIdentifier
extends DelegationTokenIdentifier {
    protected static final int MAX_TEXT_LENGTH = 32768;
    private URI uri;
    private long created = System.currentTimeMillis();
    private String origin = "";
    private String uuid = UUID.randomUUID().toString();
    private IDBTokenPayload payload = new IDBTokenPayload();
    private String tokenType = "Bearer";
    private GoogleTempCredentials marshalledCredentials = new GoogleTempCredentials();

    public CABGCPTokenIdentifier() {
        super(CloudAccessBrokerBindingConstants.CAB_TOKEN_KIND);
    }

    protected CABGCPTokenIdentifier(Text kind) {
        super(kind);
    }

    protected CABGCPTokenIdentifier(Text kind, Text owner, Text renewer, Text realUser, URI uri, String origin) {
        super(kind, owner, renewer, realUser);
        this.uri = uri;
        this.origin = origin;
    }

    protected CABGCPTokenIdentifier(Text kind, Text owner, Text renewer, URI uri, String accessToken, long expiryTime, String tokenType, String targetURL, String endpointCertificate, GoogleTempCredentials marshalledCredentials, String origin, boolean managed) {
        this(kind, owner, renewer, owner, uri, origin);
        this.payload = new IDBTokenPayload(accessToken, targetURL, expiryTime, 0L, "", endpointCertificate, managed);
        if (tokenType != null) {
            this.tokenType = tokenType;
        }
        this.marshalledCredentials = marshalledCredentials;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public long getCreated() {
        return this.created;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.uri.toString());
        Text.writeString((DataOutput)out, (String)this.origin);
        Text.writeString((DataOutput)out, (String)this.uuid);
        out.writeLong(this.created);
        this.payload.write(out);
        this.marshalledCredentials.write(out);
        Text.writeString((DataOutput)out, (String)this.tokenType);
    }

    public void readFields(DataInput in) throws DelegationTokenIOException, IOException {
        super.readFields(in);
        this.uri = URI.create(Text.readString((DataInput)in, (int)32768));
        this.origin = Text.readString((DataInput)in, (int)32768);
        this.uuid = Text.readString((DataInput)in, (int)32768);
        this.created = in.readLong();
        this.payload.readFields(in);
        this.marshalledCredentials.readFields(in);
        this.tokenType = Text.readString((DataInput)in, (int)32768);
    }

    public void validate() throws IOException {
        if (this.uri == null) {
            throw new DelegationTokenIOException("No URI in " + (Object)((Object)this));
        }
    }

    public long getExpiryTime() {
        return this.payload.getExpiryTime();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getTargetURL() {
        return this.payload.getEndpoint();
    }

    public String getAccessToken() {
        return this.payload.getAccessToken();
    }

    public String getCertificate() {
        return this.payload.getCertificate();
    }

    public boolean isManaged() {
        return this.payload.isManaged();
    }

    public GoogleTempCredentials getMarshalledCredentials() {
        return this.marshalledCredentials;
    }

    public String toString() {
        return "CloudAccessBroker GCPTokenIdentifier{GCPTokenIdentifier: " + this.getKind() + "; uri=" + this.uri + "; timestamp=" + this.created + "; uuid=" + this.uuid + "; " + this.origin + " ; " + this.payload + "; GCP Credentials{" + this.marshalledCredentials + "}; }";
    }

    public String getUuid() {
        return this.uuid;
    }

    public static String createDefaultOriginMessage() {
        return String.format(Locale.ROOT, "Created on %s at time %s.", NetUtils.getHostname(), Instant.now());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CABGCPTokenIdentifier that = (CABGCPTokenIdentifier)((Object)o);
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uri);
    }
}

