/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.common.AbstractIDBTokenRenewer;
import org.apache.knox.gateway.cloud.idbroker.common.RequestErrorHandlingAttributes;
import org.apache.knox.gateway.cloud.idbroker.google.CABGCPTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerBindingConstants;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBProperty;

public class CABGCPTokenRenewer
extends AbstractIDBTokenRenewer {
    private static final String GATEWAY_ADDRESS_PROPERTY = GoogleIDBProperty.IDBROKER_GATEWAY.getPropertyName();
    private static final String DT_PATH_PROPERTY = GoogleIDBProperty.IDBROKER_DT_PATH.getPropertyName();

    public boolean handleKind(Text text) {
        return CloudAccessBrokerBindingConstants.CAB_TOKEN_KIND.equals((Object)text);
    }

    @Override
    protected String getAccessToken(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).getAccessToken();
    }

    @Override
    protected long getTokenExpiration(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).getExpiryTime();
    }

    @Override
    protected List<String> getGatewayAddressConfigProperty(Configuration config) {
        return Arrays.asList(config.getStrings(GATEWAY_ADDRESS_PROPERTY));
    }

    @Override
    protected String getDelegationTokenPathConfigProperty(Configuration config) {
        return config.get(DT_PATH_PROPERTY);
    }

    @Override
    protected RequestErrorHandlingAttributes getRequestErrorHandlingAttributes(Configuration configuration) {
        return new RequestErrorHandlingAttributes(configuration.getInt(GoogleIDBProperty.IDBROKER_MAX_FAILOVER_ATTEMPTS.getPropertyName(), Integer.parseInt(GoogleIDBProperty.IDBROKER_MAX_FAILOVER_ATTEMPTS.getDefaultValue())), configuration.getInt(GoogleIDBProperty.IDBROKER_FAILOVER_SLEEP.getPropertyName(), Integer.parseInt(GoogleIDBProperty.IDBROKER_FAILOVER_SLEEP.getDefaultValue())), configuration.getInt(GoogleIDBProperty.IDBROKER_MAX_RETRY_ATTEMPTS.getPropertyName(), Integer.parseInt(GoogleIDBProperty.IDBROKER_MAX_RETRY_ATTEMPTS.getDefaultValue())), configuration.getInt(GoogleIDBProperty.IDBROKER_RETRY_SLEEP.getPropertyName(), Integer.parseInt(GoogleIDBProperty.IDBROKER_RETRY_SLEEP.getDefaultValue())));
    }

    @Override
    protected boolean isManagedToken(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).isManaged();
    }
}

