/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.knox.gateway.cloud.idbroker.common.DurationInfo;
import org.apache.knox.gateway.cloud.idbroker.tools.BrokerEntryPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchTokens
extends BrokerEntryPoint {
    private static final Logger LOG = LoggerFactory.getLogger(FetchTokens.class);
    public static final String USAGE = "Usage: FetchTokens <file> [-renewer <renewer>] [-r] [-p] <url1> ... <url999>\n-r: require each filesystem to issue a token\n-p: protobuf format";
    private static final String RENEWER = "renewer";
    private static final String REQUIRED = "r";
    private static final String PROTOBUF = "p";
    public static final String XMLFILE = "xmlfile";

    public FetchTokens() {
        this.setCommandFormat(new CommandFormat(2, 999, new String[]{REQUIRED, PROTOBUF}));
        this.getCommandFormat().addOptionWithValue(RENEWER);
        this.getCommandFormat().addOptionWithValue(XMLFILE);
    }

    public int run(String[] args, PrintStream stream) throws Exception {
        this.setOut(stream);
        List<String> paths = this.parseArgs(args);
        if (paths.size() < 2) {
            FetchTokens.errorln(USAGE, new Object[0]);
            return 42;
        }
        final Configuration conf = new Configuration();
        UserGroupInformation self = UserGroupInformation.getLoginUser();
        Path tokenfile = new Path(paths.get(0));
        String ropt = this.getOption(RENEWER);
        final String renewer = ropt != null ? ropt : self.getShortUserName();
        final Credentials.SerializedFormat format = this.hasOption(PROTOBUF) ? Credentials.SerializedFormat.PROTOBUF : Credentials.SerializedFormat.WRITABLE;
        final List<String> urls = paths.subList(1, paths.size());
        final boolean required = this.hasOption(REQUIRED);
        FileSystem fs = tokenfile.getFileSystem(conf);
        final Path dest = tokenfile.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        this.maybeAddXMLFileOption(conf, XMLFILE);
        this.println("Collecting tokens for %d filesystem%s to to %s", urls.size(), this.plural(urls.size()), dest);
        Credentials retrieved = (Credentials)self.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Credentials>(){

            @Override
            public Credentials run() throws Exception {
                return FetchTokens.this.saveTokens(conf, dest, renewer, required, format, urls);
            }
        });
        int n = retrieved.numberOfTokens();
        if (n > 0) {
            this.println("Saved %d token%s to %s", n, this.plural(n), dest);
        } else {
            this.println("No tokens collected, file %s unchanged", dest);
        }
        return 0;
    }

    private Credentials saveTokens(Configuration conf, Path dest, String renewer, boolean required, Credentials.SerializedFormat format, List<String> urls) throws IOException {
        Credentials cred = new Credentials();
        for (String url : urls) {
            Path path = new Path(url);
            DurationInfo ignored = new DurationInfo(LOG, "Fetching token for %s", path);
            Throwable throwable = null;
            try {
                FileSystem fs = path.getFileSystem(conf);
                URI fsUri = fs.getUri();
                LOG.debug("Acquired FS {}", (Object)fs);
                Token token = fs.getDelegationToken(renewer);
                if (token != null) {
                    this.println("Fetched token: %s", token);
                    cred.addToken(token.getService(), token);
                    continue;
                }
                this.println("No token for %s", path);
                if (!required) continue;
                throw new ExitUtil.ExitException(44, "No token issued by filesystem " + fsUri);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        try (DurationInfo ignored = new DurationInfo(LOG, "Saving tokens to %s in format %s", dest, format);){
            cred.writeTokenStorageFile(dest, conf, format);
        }
        return cred;
    }

    private String plural(int n) {
        return n == 1 ? "" : "s";
    }

    @Override
    public final int run(String[] args) throws Exception {
        return this.run(args, System.out);
    }

    public static int exec(String ... args) throws Exception {
        return ToolRunner.run((Tool)new FetchTokens(), (String[])args);
    }

    public static void main(String[] args) {
        try {
            FetchTokens.exit(FetchTokens.exec(args), "");
        }
        catch (Throwable e) {
            FetchTokens.exitOnThrowable(e);
        }
    }
}

