/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.ha.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.gateway.ha.provider.HaDescriptor;
import org.apache.hadoop.gateway.ha.provider.HaProvider;
import org.apache.hadoop.gateway.ha.provider.impl.DefaultHaProvider;
import org.apache.hadoop.gateway.ha.provider.impl.HaDescriptorManager;
import org.apache.hadoop.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.services.GatewayServices;
import org.apache.hadoop.gateway.services.registry.ServiceRegistry;

public class HaServletContextListener
implements ServletContextListener {
    public static final String PROVIDER_ATTRIBUTE_NAME = HaProvider.class.getName();
    public static final String DESCRIPTOR_LOCATION_INIT_PARAM_NAME = "haDescriptorLocation";
    public static final String DESCRIPTOR_DEFAULT_FILE_NAME = "ha.xml";
    public static final String DESCRIPTOR_DEFAULT_LOCATION = "/WEB-INF/ha.xml";
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);

    public void contextInitialized(ServletContextEvent event) {
        HaDescriptor descriptor;
        ServletContext servletContext = event.getServletContext();
        try {
            URL url = HaServletContextListener.locateDescriptor(servletContext);
            descriptor = HaServletContextListener.loadDescriptor(url);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.setupHaProvider(descriptor, servletContext);
    }

    public void contextDestroyed(ServletContextEvent event) {
        event.getServletContext().removeAttribute(PROVIDER_ATTRIBUTE_NAME);
    }

    public static HaProvider getHaProvider(ServletContext context) {
        return (HaProvider)context.getAttribute(PROVIDER_ATTRIBUTE_NAME);
    }

    private void setupHaProvider(HaDescriptor descriptor, ServletContext servletContext) {
        GatewayServices services = (GatewayServices)servletContext.getAttribute("org.apache.hadoop.gateway.gateway.services");
        String clusterName = (String)servletContext.getAttribute("org.apache.hadoop.gateway.gateway.cluster");
        ServiceRegistry serviceRegistry = (ServiceRegistry)services.getService("ServiceRegistryService");
        DefaultHaProvider provider = new DefaultHaProvider(descriptor);
        List<String> serviceNames = descriptor.getEnabledServiceNames();
        for (String serviceName : serviceNames) {
            provider.addHaService(serviceName, serviceRegistry.lookupServiceURLs(clusterName, serviceName));
        }
        servletContext.setAttribute(PROVIDER_ATTRIBUTE_NAME, (Object)provider);
    }

    private static URL locateDescriptor(ServletContext context) throws IOException {
        URL url;
        String param = context.getInitParameter(DESCRIPTOR_LOCATION_INIT_PARAM_NAME);
        if (param == null) {
            param = DESCRIPTOR_DEFAULT_LOCATION;
        }
        try {
            url = context.getResource(param);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url == null) {
            url = new URL(param);
        }
        if (url == null) {
            throw new FileNotFoundException(param);
        }
        return url;
    }

    private static HaDescriptor loadDescriptor(URL url) throws IOException {
        InputStream stream = url.openStream();
        HaDescriptor descriptor = HaDescriptorManager.load(stream);
        try {
            stream.close();
        }
        catch (IOException e) {
            LOG.failedToLoadHaDescriptor(e);
        }
        return descriptor;
    }
}

