/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.ha.provider.impl;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;

public class URLManager {
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);
    private ConcurrentLinkedQueue<String> urls = new ConcurrentLinkedQueue();

    public URLManager(List<String> urls) {
        this.urls.addAll(urls);
    }

    public String getActiveURL() {
        return this.urls.peek();
    }

    public List<String> getURLs() {
        return Lists.newArrayList(this.urls.iterator());
    }

    public void setURLs(List<String> urls) {
        if (urls != null) {
            urls.clear();
            urls.addAll(urls);
        }
    }

    public synchronized void markFailed(String url) {
        String incomingHostPort;
        String top = this.urls.peek();
        boolean pushToBottom = false;
        URI topUri = URI.create(top);
        URI incomingUri = URI.create(url);
        String topHostPort = topUri.getHost() + topUri.getPort();
        if (topHostPort.equals(incomingHostPort = incomingUri.getHost() + incomingUri.getPort())) {
            pushToBottom = true;
        }
        if (pushToBottom) {
            String failed = this.urls.poll();
            this.urls.offer(failed);
            LOG.markedFailedUrl(failed, top);
        }
    }
}

