/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.ha.provider.impl;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.gateway.ha.provider.HaDescriptor;
import org.apache.hadoop.gateway.ha.provider.HaProvider;
import org.apache.hadoop.gateway.ha.provider.HaServiceConfig;
import org.apache.hadoop.gateway.ha.provider.impl.URLManager;
import org.apache.hadoop.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;

public class DefaultHaProvider
implements HaProvider {
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);
    private HaDescriptor descriptor;
    private ConcurrentHashMap<String, URLManager> haServices;

    public DefaultHaProvider(HaDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor can not be null");
        }
        this.descriptor = descriptor;
        this.haServices = new ConcurrentHashMap();
    }

    @Override
    public HaDescriptor getHaDescriptor() {
        return this.descriptor;
    }

    @Override
    public void addHaService(String serviceName, List<String> urls) {
        this.haServices.put(serviceName, new URLManager(urls));
    }

    @Override
    public boolean isHaEnabled(String serviceName) {
        HaServiceConfig config = this.descriptor.getServiceConfig(serviceName);
        return config != null && config.isEnabled();
    }

    @Override
    public String getActiveURL(String serviceName) {
        if (this.haServices.containsKey(serviceName)) {
            return this.haServices.get(serviceName).getActiveURL();
        }
        LOG.noActiveUrlFound(serviceName);
        return null;
    }

    @Override
    public void markFailedURL(String serviceName, String url) {
        if (this.haServices.containsKey(serviceName)) {
            this.haServices.get(serviceName).markFailed(url);
        } else {
            LOG.noServiceFound(serviceName);
        }
    }
}

