/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.identityasserter.filter;

import java.util.List;
import org.apache.hadoop.gateway.deploy.DeploymentContext;
import org.apache.hadoop.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.hadoop.gateway.descriptor.FilterParamDescriptor;
import org.apache.hadoop.gateway.descriptor.ResourceDescriptor;
import org.apache.hadoop.gateway.identityasserter.filter.IdentityAsserterFilter;
import org.apache.hadoop.gateway.topology.Provider;
import org.apache.hadoop.gateway.topology.Service;

public class IdentityAsserterDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String FILTER_CLASSNAME = IdentityAsserterFilter.class.getName();
    private static final String PRINCIPAL_MAPPING_PARAM_NAME = "principal.mapping";
    private static final String GROUP_PRINCIPAL_MAPPING_PARAM_NAME = "group.principal.mapping";

    public String getRole() {
        return "identity-assertion";
    }

    public String getName() {
        return "Pseudo";
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        String mappings = (String)provider.getParams().get(PRINCIPAL_MAPPING_PARAM_NAME);
        String groupMappings = (String)provider.getParams().get(GROUP_PRINCIPAL_MAPPING_PARAM_NAME);
        context.getWebAppDescriptor().createContextParam().paramName(PRINCIPAL_MAPPING_PARAM_NAME).paramValue(mappings);
        context.getWebAppDescriptor().createContextParam().paramName(GROUP_PRINCIPAL_MAPPING_PARAM_NAME).paramValue(groupMappings);
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(FILTER_CLASSNAME).params(params);
    }
}

