/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.identityasserter.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.gateway.IdentityAsserterMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;

public class IdentityAsserterHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static IdentityAsserterMessages log = (IdentityAsserterMessages)MessagesFactory.get(IdentityAsserterMessages.class);
    private static final String PRINCIPAL_PARAM = "user.name";
    private static final String DOAS_PRINCIPAL_PARAM = "doAs";
    String username = null;

    public IdentityAsserterHttpServletRequestWrapper(HttpServletRequest request, String principal) {
        super(request);
        this.username = principal;
    }

    public String getParameter(String name) {
        if (name.equals(PRINCIPAL_PARAM)) {
            return this.username;
        }
        return super.getParameter(name);
    }

    public Map getParameterMap() {
        return this.getParams();
    }

    public Enumeration getParameterNames() {
        Map<String, String[]> params = this.getParams();
        Enumeration e = Collections.enumeration((Collection)((Object)params));
        return e;
    }

    public String[] getParameterValues(String name) {
        Map<String, String[]> params = this.getParams();
        return params.get(name);
    }

    private Map<String, String[]> getParams(String qString) {
        Map<Object, Object> params = null;
        if (this.getMethod().equals("GET")) {
            params = qString != null && qString.length() > 0 ? IdentityAsserterHttpServletRequestWrapper.parseQueryString(qString) : new HashMap();
        } else {
            if (qString == null || qString.length() == 0) {
                return null;
            }
            params = IdentityAsserterHttpServletRequestWrapper.parseQueryString(qString);
        }
        return params;
    }

    private Map<String, String[]> getParams() {
        return this.getParams(super.getQueryString());
    }

    public String getQueryString() {
        String q = null;
        Map<String, String[]> params = this.getParams();
        if (params == null) {
            params = new HashMap<String, String[]>();
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add(this.username);
        String[] a = new String[]{""};
        if ("true".equals(System.getProperty("gateway.hadoop.kerberos.secured"))) {
            params.put(DOAS_PRINCIPAL_PARAM, al.toArray(a));
            params.remove(PRINCIPAL_PARAM);
        } else {
            params.put(PRINCIPAL_PARAM, al.toArray(a));
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        q = IdentityAsserterHttpServletRequestWrapper.urlEncode(params, encoding);
        return q;
    }

    public int getContentLength() {
        String contentType = this.getContentType();
        int len = contentType != null && contentType.startsWith("application/x-www-form-urlencoded") ? -1 : super.getContentLength();
        return len;
    }

    public ServletInputStream getInputStream() throws IOException {
        String contentType = this.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = Charset.defaultCharset().name();
            }
            String body = IOUtils.toString((InputStream)super.getInputStream(), (String)encoding);
            Map<String, String[]> params = this.getParams(body);
            body = IdentityAsserterHttpServletRequestWrapper.urlEncode(params, encoding);
            return new ServletInputStreamWrapper(new ByteArrayInputStream(body.getBytes("US-ASCII")));
        }
        return super.getInputStream();
    }

    static String urlEncode(String string, String encoding) {
        try {
            return URLEncoder.encode(string, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static String urlEncode(Map<String, String[]> map, String encoding) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String name = entry.getKey();
            if (name == null || name.length() <= 0) continue;
            String[] values = entry.getValue();
            if (values == null || values.length == 0) {
                sb.append(entry.getKey());
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                if (value == null) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                try {
                    sb.append(IdentityAsserterHttpServletRequestWrapper.urlEncode(name, encoding));
                    sb.append("=");
                    sb.append(IdentityAsserterHttpServletRequestWrapper.urlEncode(value, encoding));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.skippingUnencodableParameter(name, value, encoding, e);
                }
            }
        }
        return sb.toString();
    }

    private static Map<String, String[]> parseQueryString(String queryString) {
        return HttpUtils.parseQueryString((String)queryString);
    }

    private class ServletInputStreamWrapper
    extends ServletInputStream {
        private InputStream stream;

        private ServletInputStreamWrapper(InputStream stream) {
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }
    }
}

