/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.activation.MimeType;
import javax.servlet.FilterConfig;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.gateway.filter.GatewayRequestWrapper;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteServletContextListener;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteServletFilter;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteStreamFilterFactory;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteRequestStream;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteUtil;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Resolver;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class UrlRewriteRequest
extends GatewayRequestWrapper
implements Resolver {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private UrlRewriter rewriter;
    private String urlRuleName;
    private String bodyFilterName;
    private String headersFilterName;
    private UrlRewriteFilterContentDescriptor headersFilterConfig;
    private String cookiesFilterName;
    private UrlRewriteFilterContentDescriptor cookiesFilterConfig;

    public UrlRewriteRequest(FilterConfig config, HttpServletRequest request) throws IOException {
        super(request);
        this.rewriter = UrlRewriteServletContextListener.getUrlRewriter(config.getServletContext());
        this.urlRuleName = config.getInitParameter("request.url");
        this.bodyFilterName = config.getInitParameter("request.body");
        this.headersFilterName = config.getInitParameter("request.headers");
        this.headersFilterConfig = this.getRewriteFilterConfig(this.headersFilterName, UrlRewriteServletFilter.HEADERS_MIME_TYPE);
        this.cookiesFilterName = config.getInitParameter("request.cookies");
        this.cookiesFilterConfig = this.getRewriteFilterConfig(this.cookiesFilterName, UrlRewriteServletFilter.COOKIES_MIME_TYPE);
    }

    private Template getSourceUrl() {
        Template urlTemplate;
        StringBuffer urlString = new StringBuffer(128);
        urlString.append(this.getScheme());
        urlString.append("://");
        urlString.append(this.getServerName());
        urlString.append(":");
        urlString.append(this.getServerPort());
        urlString.append(super.getRequestURI());
        String queryString = super.getQueryString();
        if (queryString != null) {
            urlString.append('?');
            urlString.append(queryString);
        }
        try {
            urlTemplate = Parser.parse((String)urlString.toString());
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(urlString.toString());
            urlTemplate = null;
        }
        return urlTemplate;
    }

    private Template getTargetUrl() {
        Template targetUrl;
        boolean rewriteRequestUrl = true;
        if (rewriteRequestUrl) {
            targetUrl = (Template)this.getAttribute("targetRequestUrl");
            if (targetUrl == null) {
                Template sourceUrl = this.getSourceUrl();
                targetUrl = this.rewriter.rewrite(this, sourceUrl, UrlRewriter.Direction.IN, this.urlRuleName);
                this.setAttribute("targetRequestUrl", targetUrl);
            }
        } else {
            targetUrl = (Template)this.getAttribute("sourceRequestUrl");
        }
        return targetUrl;
    }

    private String[] splitTargetUrl(Template url) {
        String s = url.toString();
        return s.split("\\?");
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public String getRequestURI() {
        String[] split = this.splitTargetUrl(this.getTargetUrl());
        if (split.length > 0) {
            return split[0];
        }
        return "";
    }

    public String getQueryString() {
        String[] split = this.splitTargetUrl(this.getTargetUrl());
        if (split.length > 1) {
            return split[1];
        }
        return null;
    }

    private String rewriteValue(UrlRewriter rewriter, String value, String rule) {
        try {
            Template input = Parser.parse((String)value);
            Template output = rewriter.rewrite(this, input, UrlRewriter.Direction.IN, rule);
            value = output.getPattern();
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value != null) {
            value = this.rewriteValue(this.rewriter, super.getHeader(name), UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name));
        }
        return value;
    }

    public Enumeration getHeaders(String name) {
        return new EnumerationRewriter(this.rewriter, super.getHeaders(name), UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name));
    }

    public List<String> resolve(String name) {
        return Collections.emptyList();
    }

    public ServletInputStream getInputStream() throws IOException {
        MimeType mimeType = this.getMimeType();
        UrlRewriteFilterContentDescriptor filterContentConfig = this.getRewriteFilterConfig(this.bodyFilterName, mimeType);
        InputStream stream = UrlRewriteStreamFilterFactory.create(mimeType, null, (InputStream)super.getInputStream(), this.rewriter, this, UrlRewriter.Direction.IN, filterContentConfig);
        return new UrlRewriteRequestStream(stream);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
    }

    public int getContentLength() {
        return -1;
    }

    private UrlRewriteFilterContentDescriptor getRewriteFilterConfig(String filterName, MimeType mimeType) {
        UrlRewriteFilterDescriptor filterConfig;
        UrlRewriteFilterContentDescriptor filterContentConfig = null;
        UrlRewriteRulesDescriptor rewriteConfig = this.rewriter.getConfig();
        if (rewriteConfig != null && (filterConfig = rewriteConfig.getFilter(filterName)) != null) {
            filterContentConfig = filterConfig.getContent(mimeType);
        }
        return filterContentConfig;
    }

    private class EnumerationRewriter
    implements Enumeration<String> {
        private UrlRewriter rewriter;
        private Enumeration<String> delegate;
        private String rule;

        private EnumerationRewriter(UrlRewriter rewriter, Enumeration<String> delegate, String rule) {
            this.rewriter = rewriter;
            this.delegate = delegate;
            this.rule = rule;
        }

        @Override
        public boolean hasMoreElements() {
            return this.delegate.hasMoreElements();
        }

        @Override
        public String nextElement() {
            return UrlRewriteRequest.this.rewriteValue(this.rewriter, this.delegate.nextElement(), this.rule);
        }
    }
}

