/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl.form;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteUtil;
import org.apache.hadoop.gateway.filter.rewrite.impl.form.FormPair;
import org.apache.hadoop.gateway.filter.rewrite.impl.form.FormReader;
import org.apache.hadoop.gateway.filter.rewrite.impl.form.FormWriter;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;

public class FormFilterReader
extends Reader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private int offset;
    private StringWriter writer;
    private StringBuffer buffer;
    private Reader reader;
    private FormReader parser;
    private FormWriter generator;
    private UrlRewriteFilterContentDescriptor config;

    public FormFilterReader(Reader reader, UrlRewriteFilterContentDescriptor config) throws IOException {
        this.reader = reader;
        this.config = config;
        this.parser = new FormReader(reader);
        this.writer = new StringWriter();
        this.buffer = this.writer.getBuffer();
        this.offset = 0;
        this.generator = new FormWriter(this.writer);
    }

    @Override
    public int read(char[] destBuffer, int destOffset, int destCount) throws IOException {
        int count = 0;
        int available = this.buffer.length() - this.offset;
        if (available == 0) {
            FormPair pair = this.parser.getNextPair();
            if (pair == null) {
                count = -1;
            } else {
                this.processPair();
                available = this.buffer.length() - this.offset;
            }
        }
        if (available > 0) {
            count = Math.min(destCount, available);
            this.buffer.getChars(this.offset, this.offset + count, destBuffer, destOffset);
            this.offset += count;
            if (this.offset == this.buffer.length()) {
                this.offset = 0;
                this.buffer.setLength(0);
            }
        }
        return count;
    }

    private void processPair() throws IOException {
        FormPair pair = this.parser.getCurrentPair();
        String name = pair.getName();
        String value = pair.getValue();
        String rule = UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.config, name);
        try {
            value = this.filterValue(name, pair.getValue(), rule);
            pair.setValue(value);
        }
        catch (Exception e) {
            LOG.failedToFilterValue(pair.getValue(), rule, e);
        }
        this.generator.writePair(pair);
    }

    protected String filterValue(String name, String value, String rule) {
        return value;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.reader.close();
    }
}

