/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl.xml;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.xml.XmlFilterReader;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Resolver;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class XmlUrlRewriteFilterReader
extends XmlFilterReader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private Resolver resolver;
    private UrlRewriter rewriter;
    private UrlRewriter.Direction direction;

    public XmlUrlRewriteFilterReader(Reader reader, UrlRewriter rewriter, Resolver resolver, UrlRewriter.Direction direction, UrlRewriteFilterContentDescriptor config) throws IOException, ParserConfigurationException, XMLStreamException {
        super(reader, config);
        this.resolver = resolver;
        this.rewriter = rewriter;
        this.direction = direction;
    }

    private String filterValueString(String name, String value, String rule) {
        try {
            Template input = Parser.parse((String)value);
            if (input != null) {
                Template output = this.rewriter.rewrite(this.resolver, input, this.direction, rule);
                if (output != null) {
                    value = output.getPattern();
                } else {
                    LOG.failedToFilterValue(value, rule);
                }
            } else {
                LOG.failedToParseValueForUrlRewrite(value);
            }
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }

    @Override
    protected String filterAttribute(QName elementName, QName attributeName, String attributeValue, String ruleName) {
        return this.filterValueString(attributeName.getLocalPart(), attributeValue, ruleName);
    }

    @Override
    protected String filterText(QName elementName, String text, String ruleName) {
        return this.filterValueString(elementName.getLocalPart(), text, ruleName);
    }
}

