/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.api;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRuleDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteContextImpl;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteFunctionProcessorFactory;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteRuleProcessorHolder;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteStepProcessorHolder;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.util.urltemplate.Matcher;
import org.apache.hadoop.gateway.util.urltemplate.Resolver;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class UrlRewriteProcessor
implements UrlRewriter {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    UrlRewriteEnvironment environment;
    UrlRewriteRulesDescriptor descriptor;
    Map<String, UrlRewriteRuleProcessorHolder> rules = new HashMap<String, UrlRewriteRuleProcessorHolder>();
    Matcher<UrlRewriteRuleProcessorHolder> inbound = new Matcher();
    Matcher<UrlRewriteRuleProcessorHolder> outbound = new Matcher();
    Map<String, UrlRewriteFunctionProcessor> functions = new HashMap<String, UrlRewriteFunctionProcessor>();

    public void initialize(UrlRewriteEnvironment environment, UrlRewriteRulesDescriptor descriptor) {
        this.environment = environment;
        this.descriptor = descriptor;
        this.initializeFunctions(descriptor);
        this.initializeRules(descriptor);
    }

    @Override
    public UrlRewriteRulesDescriptor getConfig() {
        return this.descriptor;
    }

    private void initializeFunctions(UrlRewriteRulesDescriptor rules) {
        for (String name : UrlRewriteFunctionDescriptorFactory.getNames()) {
            try {
                Object descriptor = rules.getFunction(name);
                UrlRewriteFunctionProcessor processor = UrlRewriteFunctionProcessorFactory.create(name, descriptor);
                processor.initialize(this.environment, descriptor);
                this.functions.put(name, processor);
            }
            catch (Exception e) {
                LOG.failedToInitializeRewriteFunctions(e);
            }
        }
    }

    private void initializeRules(UrlRewriteRulesDescriptor descriptor) {
        for (UrlRewriteRuleDescriptor ruleDescriptor : descriptor.getRules()) {
            try {
                Template template;
                UrlRewriteRuleProcessorHolder ruleProcessor = new UrlRewriteRuleProcessorHolder();
                ruleProcessor.initialize(this.environment, ruleDescriptor);
                if (!this.rules.containsKey(ruleDescriptor.name())) {
                    this.rules.put(ruleDescriptor.name(), ruleProcessor);
                }
                if ((template = ruleDescriptor.template()) == null) continue;
                EnumSet<UrlRewriter.Direction> directions = ruleDescriptor.directions();
                if (directions == null || directions.isEmpty()) {
                    this.inbound.add(template, (Object)ruleProcessor);
                    this.outbound.add(template, (Object)ruleProcessor);
                    continue;
                }
                if (directions.contains((Object)UrlRewriter.Direction.IN)) {
                    this.inbound.add(template, (Object)ruleProcessor);
                    continue;
                }
                if (!directions.contains((Object)UrlRewriter.Direction.OUT)) continue;
                this.outbound.add(template, (Object)ruleProcessor);
            }
            catch (Exception e) {
                LOG.failedToInitializeRewriteRules(e);
            }
        }
    }

    public void destroy() {
        for (UrlRewriteStepProcessorHolder urlRewriteStepProcessorHolder : this.rules.values()) {
            try {
                urlRewriteStepProcessorHolder.destroy();
            }
            catch (Exception e) {
                LOG.failedToDestroyRewriteStepProcessor(e);
            }
        }
        for (UrlRewriteFunctionProcessor urlRewriteFunctionProcessor : this.functions.values()) {
            try {
                urlRewriteFunctionProcessor.destroy();
            }
            catch (Exception e) {
                LOG.failedToDestroyRewriteFunctionProcessor(e);
            }
        }
    }

    @Override
    public Template rewrite(Resolver resolver, Template inputUri, UrlRewriter.Direction direction, String ruleName) {
        Template outputUri;
        block15: {
            outputUri = inputUri;
            UrlRewriteStepProcessorHolder stepHolder = null;
            String effectiveRuleName = null;
            if (ruleName == null || "*".equals(ruleName)) {
                ruleName = null;
                Matcher.Match match = null;
                switch (direction) {
                    case IN: {
                        match = this.inbound.match(outputUri);
                        break;
                    }
                    case OUT: {
                        match = this.outbound.match(outputUri);
                    }
                }
                if (match != null) {
                    stepHolder = (UrlRewriteStepProcessorHolder)match.getValue();
                    effectiveRuleName = ((UrlRewriteRuleProcessorHolder)match.getValue()).getRuleName();
                }
            } else if (!ruleName.isEmpty()) {
                stepHolder = this.rules.get(ruleName);
                effectiveRuleName = ruleName;
            }
            if (stepHolder != null) {
                UrlRewriteContextImpl context = new UrlRewriteContextImpl(this.environment, resolver, this.functions, direction, inputUri);
                try {
                    UrlRewriteStepStatus stepStatus = stepHolder.process(context);
                    if (UrlRewriteStepStatus.SUCCESS == stepStatus) {
                        outputUri = context.getCurrentUrl();
                        if (ruleName == null) {
                            LOG.rewroteUrlViaImplicitRule(inputUri, direction, effectiveRuleName, outputUri);
                        } else {
                            LOG.rewroteUrlViaExplicitRule(inputUri, direction, effectiveRuleName, outputUri);
                        }
                        break block15;
                    }
                    LOG.failedToRewriteUrl(inputUri, direction, effectiveRuleName, stepStatus);
                    outputUri = null;
                }
                catch (Exception e) {
                    LOG.failedToRewriteUrlDueToException(inputUri, direction, effectiveRuleName, e);
                    outputUri = null;
                }
            } else {
                LOG.noRuleMatchingUrl(inputUri, direction);
            }
        }
        return outputUri;
    }
}

