/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteProcessor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteServletEnvironment;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;

public class UrlRewriteServletContextListener
implements ServletContextListener {
    public static final String PROCESSOR_ATTRIBUTE_NAME = UrlRewriteProcessor.class.getName();
    public static final String DESCRIPTOR_LOCATION_INIT_PARAM_NAME = "rewriteDescriptorLocation";
    public static final String DESCRIPTOR_DEFAULT_FILE_NAME = "rewrite.xml";
    public static final String DESCRIPTOR_DEFAULT_LOCATION = "/WEB-INF/rewrite.xml";
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);

    public void contextInitialized(ServletContextEvent event) {
        UrlRewriteRulesDescriptor descriptor = null;
        try {
            URL url = UrlRewriteServletContextListener.locateDescriptor(event.getServletContext());
            descriptor = UrlRewriteServletContextListener.loadDescriptor(url);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ServletContext context = event.getServletContext();
        UrlRewriteServletEnvironment environment = new UrlRewriteServletEnvironment(context);
        UrlRewriteProcessor processor = new UrlRewriteProcessor();
        processor.initialize(environment, descriptor);
        event.getServletContext().setAttribute(PROCESSOR_ATTRIBUTE_NAME, (Object)processor);
    }

    public void contextDestroyed(ServletContextEvent event) {
        UrlRewriteProcessor processor = (UrlRewriteProcessor)event.getServletContext().getAttribute(PROCESSOR_ATTRIBUTE_NAME);
        event.getServletContext().removeAttribute(PROCESSOR_ATTRIBUTE_NAME);
        if (processor != null) {
            processor.destroy();
        }
    }

    public static UrlRewriter getUrlRewriter(ServletContext context) {
        return (UrlRewriteProcessor)context.getAttribute(PROCESSOR_ATTRIBUTE_NAME);
    }

    private static URL locateDescriptor(ServletContext context) throws IOException {
        URL url;
        String param = context.getInitParameter(DESCRIPTOR_LOCATION_INIT_PARAM_NAME);
        if (param == null) {
            param = DESCRIPTOR_DEFAULT_LOCATION;
        }
        try {
            url = context.getResource(param);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url == null) {
            url = new URL(param);
        }
        if (url == null) {
            throw new FileNotFoundException(param);
        }
        return url;
    }

    private static UrlRewriteRulesDescriptor loadDescriptor(URL url) throws IOException {
        InputStream stream = url.openStream();
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        UrlRewriteRulesDescriptor descriptor = UrlRewriteRulesDescriptorFactory.load("xml", reader);
        try {
            ((Reader)reader).close();
        }
        catch (IOException closeException) {
            LOG.failedToLoadRewriteRulesDescriptor(closeException);
        }
        return descriptor;
    }
}

