/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFlowDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteStepDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteStepFlow;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteStepProcessorFactory;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteStepProcessorState;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;

public class UrlRewriteStepProcessorHolder
implements UrlRewriteStepProcessor {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private boolean isCondition;
    private UrlRewriteStepDescriptor descriptor;
    private UrlRewriteStepProcessor processor;
    private List<UrlRewriteStepProcessorHolder> childProcessors;

    @Override
    public String getType() {
        return "system";
    }

    public boolean isCondition() {
        return this.isCondition;
    }

    public boolean isAction() {
        return !this.isCondition;
    }

    public void initialize(UrlRewriteEnvironment environment, UrlRewriteStepDescriptor descriptor) throws Exception {
        UrlRewriteStepProcessor processor = UrlRewriteStepProcessorFactory.create(descriptor);
        processor.initialize(environment, descriptor);
        this.initialize(environment, descriptor, processor);
    }

    void initialize(UrlRewriteEnvironment environment, UrlRewriteStepDescriptor descriptor, UrlRewriteStepProcessor processor) throws Exception {
        UrlRewriteFlowDescriptor flowDescriptor;
        List<UrlRewriteStepDescriptor> stepList;
        this.descriptor = descriptor;
        this.processor = processor;
        this.isCondition = descriptor instanceof UrlRewriteFlowDescriptor;
        this.childProcessors = new ArrayList<UrlRewriteStepProcessorHolder>();
        if (this.isCondition && (stepList = (flowDescriptor = (UrlRewriteFlowDescriptor)descriptor).steps()) != null && !stepList.isEmpty()) {
            for (UrlRewriteStepDescriptor stepDescriptor : stepList) {
                UrlRewriteStepProcessorHolder stepProcessor = new UrlRewriteStepProcessorHolder();
                stepProcessor.initialize(environment, stepDescriptor);
                this.childProcessors.add(stepProcessor);
            }
        }
    }

    UrlRewriteStepDescriptor getDescriptor() {
        return this.descriptor;
    }

    UrlRewriteStepProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        UrlRewriteStepStatus status = UrlRewriteStepStatus.SUCCESS;
        if (this.processor != null && UrlRewriteStepStatus.SUCCESS == (status = this.processor.process(context)) && this.descriptor instanceof UrlRewriteFlowDescriptor && !this.childProcessors.isEmpty()) {
            UrlRewriteFlowDescriptor flowDescriptor = (UrlRewriteFlowDescriptor)this.descriptor;
            UrlRewriteStepFlow flow = flowDescriptor.flow();
            if (flow == null) {
                flow = UrlRewriteStepFlow.AND;
            }
            switch (flow) {
                case ALL: {
                    return this.processAllFlow(context);
                }
                case AND: {
                    return this.processAndFlow(context);
                }
                case OR: {
                    return this.processOrFlow(context);
                }
            }
        }
        return status;
    }

    private UrlRewriteStepStatus processAllFlow(UrlRewriteContext context) throws Exception {
        UrlRewriteStepProcessorState state = new UrlRewriteStepProcessorState(this.childProcessors.iterator());
        UrlRewriteStepStatus stepStatus = UrlRewriteStepStatus.SUCCESS;
        while (state.hasNext()) {
            while (state.hasNextCondition()) {
                UrlRewriteStepProcessorHolder step = state.nextCondition(stepStatus);
                if ((stepStatus = step.process(context)) != UrlRewriteStepStatus.FINISHED) continue;
                return stepStatus;
            }
            stepStatus = this.processActions(context, state);
            if (stepStatus != UrlRewriteStepStatus.FINISHED) continue;
            return stepStatus;
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    private UrlRewriteStepStatus processAndFlow(UrlRewriteContext context) throws Exception {
        UrlRewriteStepProcessorState state = new UrlRewriteStepProcessorState(this.childProcessors.iterator());
        UrlRewriteStepStatus stepStatus = UrlRewriteStepStatus.SUCCESS;
        while (state.hasNext()) {
            while (state.hasNextCondition()) {
                UrlRewriteStepProcessorHolder step = state.nextCondition(stepStatus);
                if ((stepStatus = step.process(context)) == UrlRewriteStepStatus.SUCCESS) continue;
                return stepStatus;
            }
            stepStatus = this.processActions(context, state);
            if (stepStatus == UrlRewriteStepStatus.SUCCESS) continue;
            return stepStatus;
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    private UrlRewriteStepStatus processOrFlow(UrlRewriteContext context) throws Exception {
        UrlRewriteStepProcessorState state = new UrlRewriteStepProcessorState(this.childProcessors.iterator());
        UrlRewriteStepStatus status = UrlRewriteStepStatus.SUCCESS;
        while (state.hasNext()) {
            UrlRewriteStepStatus flowStatus = UrlRewriteStepStatus.FAILURE;
            block5: while (state.hasNextCondition()) {
                UrlRewriteStepProcessorHolder step = state.nextCondition(status);
                if (flowStatus != UrlRewriteStepStatus.FAILURE) continue;
                status = step.process(context);
                switch (status) {
                    case SUCCESS: {
                        flowStatus = UrlRewriteStepStatus.SUCCESS;
                        continue block5;
                    }
                    case FINISHED: {
                        return status;
                    }
                }
            }
            status = this.processActions(context, state);
            if (status == UrlRewriteStepStatus.SUCCESS) continue;
            return status;
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    private UrlRewriteStepStatus processActions(UrlRewriteContext context, UrlRewriteStepProcessorState state) throws Exception {
        UrlRewriteStepStatus flowStatus = UrlRewriteStepStatus.SUCCESS;
        block4: while (state.hasNextAction()) {
            if (flowStatus != UrlRewriteStepStatus.SUCCESS) continue;
            UrlRewriteStepStatus stepStatus = UrlRewriteStepStatus.SUCCESS;
            UrlRewriteStepProcessorHolder step = state.nextAction(stepStatus);
            stepStatus = step.process(context);
            switch (stepStatus) {
                case FAILURE: {
                    flowStatus = UrlRewriteStepStatus.FAILURE;
                    continue block4;
                }
                case FINISHED: {
                    return stepStatus;
                }
            }
        }
        return flowStatus;
    }

    @Override
    public void destroy() throws Exception {
        this.destroy(this.processor);
        if (this.descriptor instanceof UrlRewriteFlowDescriptor) {
            for (UrlRewriteStepProcessorHolder childProcessor : this.childProcessors) {
                this.destroy(childProcessor);
            }
        }
    }

    public void destroy(UrlRewriteStepProcessor processor) {
        if (processor != null) {
            try {
                processor.destroy();
            }
            catch (Exception e) {
                LOG.failedToDestroyRewriteStepProcessor(e);
            }
        }
    }
}

