/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl.form;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.hadoop.gateway.filter.rewrite.impl.form.FormPair;

public class FormReader {
    private static final String DEFFAULT_FORM_ENCODING = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private Reader reader;
    private FormPair current;
    private StringBuilder buffer;
    private int sepIndex;

    public FormReader(Reader reader) {
        this.reader = reader;
        this.current = null;
        this.buffer = new StringBuilder(1024);
        this.sepIndex = -1;
    }

    public FormPair getNextPair() throws IOException {
        block5: while (true) {
            int c = this.reader.read();
            switch (c) {
                case 61: {
                    this.sepIndex = this.buffer.length();
                    continue block5;
                }
                case 38: {
                    if (this.buffer.length() == 0) {
                        this.sepIndex = -1;
                        continue block5;
                    }
                    return this.createCurrentPair();
                }
                case -1: {
                    if (this.buffer.length() == 0) {
                        this.sepIndex = -1;
                        return null;
                    }
                    return this.createCurrentPair();
                }
            }
            this.buffer.append((char)c);
        }
    }

    private FormPair createCurrentPair() throws UnsupportedEncodingException {
        FormPair pair;
        String value;
        String name;
        if (this.sepIndex >= 0) {
            name = this.buffer.substring(0, this.sepIndex);
            value = this.buffer.substring(this.sepIndex);
        } else {
            name = this.buffer.toString();
            value = "";
        }
        name = URLDecoder.decode(name, DEFFAULT_FORM_ENCODING);
        value = URLDecoder.decode(value, DEFFAULT_FORM_ENCODING);
        this.current = pair = new FormPair(name, value);
        this.buffer.setLength(0);
        this.sepIndex = -1;
        return pair;
    }

    public FormPair getCurrentPair() {
        return this.current;
    }
}

