/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl.html;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StreamedSource;
import net.htmlparser.jericho.Tag;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class HtmlFilterReaderBase
extends Reader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private Document document;
    private Stack<Level> stack;
    private Reader reader;
    private StreamedSource parser;
    private Iterator<Segment> iterator;
    private int lastSegEnd;
    private int offset;
    private StringWriter writer;
    private StringBuffer buffer;

    protected HtmlFilterReaderBase(Reader reader) throws IOException, ParserConfigurationException {
        this.reader = reader;
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.stack = new Stack();
        this.parser = new StreamedSource(reader);
        this.iterator = this.parser.iterator();
        this.writer = new StringWriter();
        this.buffer = this.writer.getBuffer();
        this.offset = 0;
    }

    protected abstract String filterAttribute(QName var1, QName var2, String var3, String var4);

    protected abstract String filterText(QName var1, String var2, String var3);

    @Override
    public int read(char[] destBuffer, int destOffset, int destCount) throws IOException {
        int count = 0;
        int available = this.buffer.length() - this.offset;
        if (available == 0) {
            if (this.iterator.hasNext()) {
                this.iterator.next();
                this.processCurrentSegment();
                available = this.buffer.length() - this.offset;
            } else {
                count = -1;
            }
        }
        if (available > 0) {
            count = Math.min(destCount, available);
            this.buffer.getChars(this.offset, this.offset + count, destBuffer, destOffset);
            this.offset += count;
            if (this.offset == this.buffer.length()) {
                this.offset = 0;
                this.buffer.setLength(0);
            }
        }
        return count;
    }

    private void processCurrentSegment() {
        Segment segment = this.parser.getCurrentSegment();
        if (segment.getEnd() <= this.lastSegEnd) {
            return;
        }
        this.lastSegEnd = segment.getEnd();
        if (segment instanceof Tag) {
            if (segment instanceof StartTag) {
                this.processStartTag((StartTag)segment);
            } else if (segment instanceof EndTag) {
                this.processEndTag((EndTag)segment);
            } else {
                this.writer.write(segment.toString());
            }
        } else {
            this.processText(segment);
        }
    }

    private void processEndTag(EndTag tag) {
        Level popped;
        while (!this.stack.isEmpty() && !(popped = this.stack.pop()).getTag().getName().equalsIgnoreCase(tag.getName())) {
        }
        this.writer.write(tag.toString());
    }

    private void processStartTag(StartTag tag) {
        if ("<".equals(tag.getTagType().getStartDelimiter())) {
            Element e = this.document.createElement(tag.getNameSegment().toString());
            this.stack.push(new Level(tag));
            this.writer.write("<");
            this.writer.write(tag.getNameSegment().toString());
            Attributes attributes = tag.getAttributes();
            if (!attributes.isEmpty()) {
                for (Attribute attribute : attributes) {
                    this.processAttribute(attribute);
                }
            }
            if (tag.toString().trim().endsWith("/>") || tag.isEmptyElementTag()) {
                this.stack.pop();
                this.writer.write("/>");
            } else {
                this.writer.write(">");
            }
        } else {
            this.writer.write(tag.toString());
        }
    }

    private void processAttribute(Attribute attribute) {
        String inputValue;
        String outputValue = inputValue = attribute.getValue();
        try {
            Level tag = this.stack.peek();
            outputValue = this.filterAttribute(tag.getQName(), tag.getQName(attribute.getName()), inputValue, null);
            if (outputValue == null) {
                outputValue = inputValue;
            }
        }
        catch (Exception e) {
            LOG.failedToFilterAttribute(attribute.getName(), e);
        }
        this.writer.write(" ");
        this.writer.write(attribute.getName());
        this.writer.write("=");
        this.writer.write(attribute.getQuoteChar());
        this.writer.write(outputValue);
        this.writer.write(attribute.getQuoteChar());
    }

    private void processText(Segment segment) {
        String inputValue;
        String outputValue = inputValue = segment.toString();
        try {
            if (!this.stack.isEmpty()) {
                outputValue = this.filterText(this.stack.peek().getQName(), inputValue, null);
            }
            if (outputValue == null) {
                outputValue = inputValue;
            }
        }
        catch (Exception e) {
            LOG.failedToFilterValue(inputValue, null, e);
        }
        this.writer.write(outputValue);
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        this.reader.close();
        this.writer.close();
        this.stack.clear();
    }

    private String getNamespace(String prefix) {
        Level level;
        String namespace = null;
        Iterator i$ = this.stack.iterator();
        while (i$.hasNext() && (namespace = (level = (Level)i$.next()).getNamespace(prefix)) == null) {
        }
        return namespace;
    }

    private static class Level {
        private StartTag tag;
        private QName name;
        private Map<String, String> namespaces;

        private Level(StartTag tag) {
            this.tag = tag;
            this.name = null;
            this.namespaces = null;
        }

        private StartTag getTag() {
            return this.tag;
        }

        private QName getQName() {
            if (this.name == null) {
                this.name = this.getQName(this.tag.getName());
            }
            return this.name;
        }

        private String getNamespace(String prefix) {
            return this.getNamespaces().get(prefix);
        }

        private QName getQName(String name) {
            String local;
            String prefix;
            int colon;
            int n = colon = name == null ? -1 : name.indexOf(58);
            if (colon < 0) {
                prefix = "";
                local = name;
            } else {
                prefix = name.substring(0, colon);
                local = colon + 1 < name.length() ? name.substring(colon + 1) : "";
            }
            String namespace = prefix == null ? null : this.getNamespace(prefix);
            return new QName(namespace, local, prefix);
        }

        private Map<String, String> getNamespaces() {
            if (this.namespaces == null) {
                this.namespaces = new HashMap<String, String>();
                this.parseNamespaces();
            }
            return this.namespaces;
        }

        private void parseNamespaces() {
            Attributes attributes = this.tag.getAttributes();
            if (attributes != null) {
                for (Attribute attribute : this.tag.getAttributes()) {
                    String name = attribute.getName();
                    if (!name.toLowerCase().startsWith("xmlns")) continue;
                    int colon = name.indexOf(":", 5);
                    String prefix = colon == 0 ? "" : name.substring(colon);
                    this.namespaces.put(prefix, attribute.getValue());
                }
            }
        }
    }
}

