/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl.json;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.json.JsonFilterReader;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Resolver;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class JsonUrlRewriteFilterReader
extends JsonFilterReader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private Resolver resolver;
    private UrlRewriter rewriter;
    private UrlRewriter.Direction direction;

    public JsonUrlRewriteFilterReader(Reader reader, UrlRewriter rewriter, Resolver resolver, UrlRewriter.Direction direction, UrlRewriteFilterContentDescriptor config) throws IOException {
        super(reader, config);
        this.resolver = resolver;
        this.rewriter = rewriter;
        this.direction = direction;
    }

    @Override
    protected String filterValueString(String name, String value, String rule) {
        try {
            Template input = Parser.parse((String)value);
            Template output = this.rewriter.rewrite(this.resolver, input, this.direction, rule);
            value = output.getPattern();
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }
}

