/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.hadoopauth.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.gateway.deploy.DeploymentContext;
import org.apache.hadoop.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.hadoop.gateway.descriptor.FilterParamDescriptor;
import org.apache.hadoop.gateway.descriptor.ResourceDescriptor;
import org.apache.hadoop.gateway.topology.Provider;
import org.apache.hadoop.gateway.topology.Service;

public class HadoopAuthDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String ROLE = "authentication";
    private static final String NAME = "HadoopAuth";
    private static final String HADOOPAUTH_FILTER_CLASSNAME = "org.apache.hadoop.gateway.hadoopauth.filter.HadoopAuthFilter";
    private static final String HADOOPAUTH_POSTFILTER_CLASSNAME = "org.apache.hadoop.gateway.hadoopauth.filter.HadoopAuthPostFilter";

    public String getRole() {
        return ROLE;
    }

    public String getName() {
        return NAME;
    }

    public void initializeContribution(DeploymentContext context) {
        super.initializeContribution(context);
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map providerParams = provider.getParams();
        for (Map.Entry entry : providerParams.entrySet()) {
            params.add(resource.createFilterParam().name(((String)entry.getKey()).toLowerCase()).value((String)entry.getValue()));
        }
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(HADOOPAUTH_FILTER_CLASSNAME).params(params);
        resource.addFilter().name("Post" + this.getName()).role(this.getRole()).impl(HADOOPAUTH_POSTFILTER_CLASSNAME).params(params);
    }
}

