/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.yarn.rm;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.gateway.deploy.DeploymentContext;
import org.apache.hadoop.gateway.deploy.ServiceDeploymentContributorBase;
import org.apache.hadoop.gateway.descriptor.FilterParamDescriptor;
import org.apache.hadoop.gateway.descriptor.ResourceDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.hadoop.gateway.topology.Service;

public class ResourceManagerDeploymentContributor
extends ServiceDeploymentContributorBase {
    private static final String RULES_RESOURCE = ResourceManagerDeploymentContributor.class.getName().replace('.', '/') + "/rewrite.xml";
    private static final String EXTERNAL_PATH = "/resourcemanager";
    private static final String PROXY_PATH = "/resourcemanager/proxy";

    public String getRole() {
        return "RESOURCEMANAGER";
    }

    public String getName() {
        return "resourcemanager";
    }

    public void contributeService(DeploymentContext context, Service service) throws Exception {
        this.contributeRewriteRules(context, service);
        this.contributeResources(context, service);
    }

    private void contributeRewriteRules(DeploymentContext context, Service service) throws URISyntaxException, IOException {
        UrlRewriteRulesDescriptor serviceRules = this.loadRulesFromClassPath();
        UrlRewriteRulesDescriptor clusterRules = (UrlRewriteRulesDescriptor)context.getDescriptor("rewrite");
        clusterRules.addRules(serviceRules);
    }

    private UrlRewriteRulesDescriptor loadRulesFromClassPath() throws IOException {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(RULES_RESOURCE);
        InputStreamReader reader = new InputStreamReader(stream);
        UrlRewriteRulesDescriptor rules = UrlRewriteRulesDescriptorFactory.load((String)"xml", (Reader)reader);
        ((Reader)reader).close();
        stream.close();
        return rules;
    }

    private void contributeResources(DeploymentContext context, Service service) throws URISyntaxException {
        HashMap<String, String> filterParams = new HashMap<String, String>();
        this.contributeResource(context, service, "/resourcemanager/v1/cluster/", null);
        this.contributeResource(context, service, "/resourcemanager/v1/cluster/**?**", null);
        filterParams.clear();
        filterParams.put("response.body", this.getQualifiedName() + "/apps/outbound");
        this.contributeResource(context, service, "/resourcemanager/v1/cluster/apps?**", filterParams);
        filterParams.clear();
        filterParams.put("response.body", this.getQualifiedName() + "/app/outbound");
        this.contributeResource(context, service, "/resourcemanager/v1/cluster/apps/*?**", filterParams);
        filterParams.clear();
        filterParams.put("response.body", this.getQualifiedName() + "/appattempts/outbound");
        this.contributeResource(context, service, "/resourcemanager/v1/cluster/apps/*/appattempts?**", filterParams);
        filterParams.clear();
        filterParams.put("response.body", this.getQualifiedName() + "/nodes/outbound");
        this.contributeResource(context, service, "/resourcemanager/v1/cluster/nodes?**", filterParams);
        filterParams.clear();
        filterParams.put("request.url", this.getQualifiedName() + "/nodeId/inbound");
        filterParams.put("response.body", this.getQualifiedName() + "/node/outbound");
        this.contributeResource(context, service, "/resourcemanager/v1/cluster/nodes/*?**", filterParams);
        filterParams.clear();
        filterParams.put("request.url", this.getQualifiedName() + "/inbound/proxy");
        this.contributeResource(context, service, "/resourcemanager/proxy/*/ws/v1/**?**", filterParams);
        filterParams.clear();
        filterParams.put("response.body", this.getQualifiedName() + "/proxy/jobattempts/outbound");
        this.contributeResource(context, service, "/resourcemanager/proxy/*/ws/v1/mapreduce/jobs/*/jobattempts", filterParams);
        filterParams.clear();
        filterParams.put("response.body", this.getQualifiedName() + "/proxy/taskattempts/outbound");
        this.contributeResource(context, service, "/resourcemanager/proxy/*/ws/v1/mapreduce/jobs/*/tasks/*/attempts", filterParams);
        filterParams.clear();
        filterParams.put("response.body", this.getQualifiedName() + "/proxy/taskattempt/outbound");
        this.contributeResource(context, service, "/resourcemanager/proxy/*/ws/v1/mapreduce/jobs/*/tasks/*/attempts/*", filterParams);
    }

    private void contributeResource(DeploymentContext context, Service service, String pattern, Map<String, String> filterParams) throws URISyntaxException {
        ArrayList<FilterParamDescriptor> params = new ArrayList<FilterParamDescriptor>();
        ResourceDescriptor resource = context.getGatewayDescriptor().addResource();
        resource.role(service.getRole());
        resource.pattern(pattern);
        this.addWebAppSecFilters(context, service, resource);
        this.addAuthenticationFilter(context, service, resource);
        this.addIdentityAssertionFilter(context, service, resource);
        this.addAuthorizationFilter(context, service, resource);
        if (filterParams != null) {
            for (Map.Entry<String, String> filterParam : filterParams.entrySet()) {
                params.add(resource.createFilterParam().name(filterParam.getKey()).value(filterParam.getValue()));
            }
        }
        this.addRewriteFilter(context, service, resource, params);
        this.addDispatchFilter(context, service, resource, "dispatch", "http-client");
    }

    private String getQualifiedName() {
        return this.getRole() + "/" + this.getName();
    }
}

