/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.i18n.GatewayUtilCommonMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class CookieUtils {
    private static final GatewayUtilCommonMessages LOGGER = (GatewayUtilCommonMessages)MessagesFactory.get(GatewayUtilCommonMessages.class);

    private CookieUtils() {
    }

    public static List<Cookie> getCookiesForName(HttpServletRequest request, String name) {
        ArrayList<Cookie> cookiesByName = new ArrayList<Cookie>();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                cookiesByName.add(cookie);
            }
        }
        if (cookiesByName.isEmpty()) {
            LOGGER.cookieNotFound(name);
        }
        return cookiesByName;
    }
}

