/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class KeyRange {
    private byte[] primaryKeyStart;
    private byte[] primaryKeyEnd;
    private long dataSizeBytes;
    private LocatedTablet tablet;

    public KeyRange(LocatedTablet tablet, byte[] primaryKeyStart, byte[] primaryKeyEnd, long dataSizeBytes) {
        Preconditions.checkNotNull(tablet);
        this.tablet = tablet;
        this.primaryKeyStart = primaryKeyStart;
        this.primaryKeyEnd = primaryKeyEnd;
        this.dataSizeBytes = dataSizeBytes;
    }

    public byte[] getPrimaryKeyStart() {
        return this.primaryKeyStart;
    }

    public byte[] getPrimaryKeyEnd() {
        return this.primaryKeyEnd;
    }

    public LocatedTablet getTablet() {
        return this.tablet;
    }

    public byte[] getPartitionKeyStart() {
        return this.tablet.getPartition().getPartitionKeyStart();
    }

    public byte[] getPartitionKeyEnd() {
        return this.tablet.getPartition().getPartitionKeyEnd();
    }

    public long getDataSizeBytes() {
        return this.dataSizeBytes;
    }

    public String toString() {
        return String.format("[%s, %s), %s, %s", this.primaryKeyStart == null || this.primaryKeyStart.length == 0 ? "<start>" : Bytes.hex(this.primaryKeyStart), this.primaryKeyEnd == null || this.primaryKeyEnd.length == 0 ? "<end>" : Bytes.hex(this.primaryKeyEnd), String.valueOf(this.dataSizeBytes), this.tablet.toString());
    }
}

