/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.PartialRow;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Impala"})
@InterfaceStability.Unstable
public class PartitionSchema {
    private final RangeSchema rangeSchema;
    private final List<HashBucketSchema> hashBucketSchemas;
    private final boolean isSimple;

    PartitionSchema(RangeSchema rangeSchema, List<HashBucketSchema> hashBucketSchemas, Schema schema2) {
        boolean isSimple;
        this.rangeSchema = rangeSchema;
        this.hashBucketSchemas = hashBucketSchemas;
        boolean bl = isSimple = hashBucketSchemas.isEmpty() && rangeSchema.columns.size() == schema2.getPrimaryKeyColumnCount();
        if (isSimple) {
            int i = 0;
            for (Integer id : rangeSchema.columns) {
                if (schema2.getColumnIndex(id) == i++) continue;
                isSimple = false;
                break;
            }
        }
        this.isSimple = isSimple;
    }

    public byte[] encodePartitionKey(PartialRow row) {
        return KeyEncoder.encodePartitionKey(row, this);
    }

    public RangeSchema getRangeSchema() {
        return this.rangeSchema;
    }

    public List<HashBucketSchema> getHashBucketSchemas() {
        return this.hashBucketSchemas;
    }

    boolean isSimpleRangePartitioning() {
        return this.isSimple;
    }

    public static class HashBucketSchema {
        private final List<Integer> columnIds;
        private int numBuckets;
        private int seed;

        HashBucketSchema(List<Integer> columnIds, int numBuckets, int seed) {
            this.columnIds = columnIds;
            this.numBuckets = numBuckets;
            this.seed = seed;
        }

        public List<Integer> getColumnIds() {
            return this.columnIds;
        }

        public int getNumBuckets() {
            return this.numBuckets;
        }

        public int getSeed() {
            return this.seed;
        }
    }

    public static class RangeSchema {
        private final List<Integer> columns;

        RangeSchema(List<Integer> columns) {
            this.columns = columns;
        }

        public List<Integer> getColumns() {
            return this.columns;
        }
    }
}

