/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.kudu;

import java.util.ArrayList;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class SparkUtil$ {
    public static final SparkUtil$ MODULE$;

    static {
        new SparkUtil$();
    }

    public DataType kuduTypeToSparkType(Type t, ColumnTypeAttributes a) {
        block13: {
            BooleanType$ booleanType$;
            block3: {
                Type type;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        type = t;
                                                        if (!((Object)((Object)Type.BOOL)).equals((Object)type)) break block2;
                                                        booleanType$ = BooleanType$.MODULE$;
                                                        break block3;
                                                    }
                                                    if (!((Object)((Object)Type.INT8)).equals((Object)type)) break block4;
                                                    booleanType$ = ByteType$.MODULE$;
                                                    break block3;
                                                }
                                                if (!((Object)((Object)Type.INT16)).equals((Object)type)) break block5;
                                                booleanType$ = ShortType$.MODULE$;
                                                break block3;
                                            }
                                            if (!((Object)((Object)Type.INT32)).equals((Object)type)) break block6;
                                            booleanType$ = IntegerType$.MODULE$;
                                            break block3;
                                        }
                                        if (!((Object)((Object)Type.INT64)).equals((Object)type)) break block7;
                                        booleanType$ = LongType$.MODULE$;
                                        break block3;
                                    }
                                    if (!((Object)((Object)Type.UNIXTIME_MICROS)).equals((Object)type)) break block8;
                                    booleanType$ = TimestampType$.MODULE$;
                                    break block3;
                                }
                                if (!((Object)((Object)Type.FLOAT)).equals((Object)type)) break block9;
                                booleanType$ = FloatType$.MODULE$;
                                break block3;
                            }
                            if (!((Object)((Object)Type.DOUBLE)).equals((Object)type)) break block10;
                            booleanType$ = DoubleType$.MODULE$;
                            break block3;
                        }
                        if (!((Object)((Object)Type.STRING)).equals((Object)type)) break block11;
                        booleanType$ = StringType$.MODULE$;
                        break block3;
                    }
                    if (!((Object)((Object)Type.BINARY)).equals((Object)type)) break block12;
                    booleanType$ = BinaryType$.MODULE$;
                    break block3;
                }
                if (!((Object)((Object)Type.DECIMAL)).equals((Object)type)) break block13;
                booleanType$ = new DecimalType(a.getPrecision(), a.getScale());
            }
            return booleanType$;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No support for Kudu type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t})));
    }

    public Type sparkTypeToKuduType(DataType dt) {
        block13: {
            Type type;
            block3: {
                DataType dataType;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        dataType = dt;
                                                        DataType dataType2 = DataTypes.BinaryType;
                                                        DataType dataType3 = dataType;
                                                        if (dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null) break block2;
                                                        type = Type.BINARY;
                                                        break block3;
                                                    }
                                                    DataType dataType4 = DataTypes.BooleanType;
                                                    DataType dataType5 = dataType;
                                                    if (dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null) break block4;
                                                    type = Type.BOOL;
                                                    break block3;
                                                }
                                                DataType dataType6 = DataTypes.StringType;
                                                DataType dataType7 = dataType;
                                                if (dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null) break block5;
                                                type = Type.STRING;
                                                break block3;
                                            }
                                            DataType dataType8 = DataTypes.TimestampType;
                                            DataType dataType9 = dataType;
                                            if (dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null) break block6;
                                            type = Type.UNIXTIME_MICROS;
                                            break block3;
                                        }
                                        DataType dataType10 = DataTypes.ByteType;
                                        DataType dataType11 = dataType;
                                        if (dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null) break block7;
                                        type = Type.INT8;
                                        break block3;
                                    }
                                    DataType dataType12 = DataTypes.ShortType;
                                    DataType dataType13 = dataType;
                                    if (dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null) break block8;
                                    type = Type.INT16;
                                    break block3;
                                }
                                DataType dataType14 = DataTypes.IntegerType;
                                DataType dataType15 = dataType;
                                if (dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null) break block9;
                                type = Type.INT32;
                                break block3;
                            }
                            DataType dataType16 = DataTypes.LongType;
                            DataType dataType17 = dataType;
                            if (dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null) break block10;
                            type = Type.INT64;
                            break block3;
                        }
                        DataType dataType18 = DataTypes.FloatType;
                        DataType dataType19 = dataType;
                        if (dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null) break block11;
                        type = Type.FLOAT;
                        break block3;
                    }
                    DataType dataType20 = DataTypes.DoubleType;
                    DataType dataType21 = dataType;
                    if (dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null) break block12;
                    type = Type.DOUBLE;
                    break block3;
                }
                if (!DecimalType$.MODULE$.unapply(dataType)) break block13;
                type = Type.DECIMAL;
            }
            return type;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No support for Spark SQL type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt})));
    }

    public StructType sparkSchema(Schema kuduSchema2, Option<Seq<String>> fields) {
        Option<Seq<String>> option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    option = fields;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Seq fieldNames = (Seq)some.x();
                    seq = (Seq)fieldNames.map((Function1)new Serializable(kuduSchema2){
                        public static final long serialVersionUID = 0L;
                        private final Schema kuduSchema$1;

                        public final ColumnSchema apply(String x$1) {
                            return this.kuduSchema$1.getColumn(x$1);
                        }
                        {
                            this.kuduSchema$1 = kuduSchema$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(kuduSchema2.getColumns()).asScala();
            }
            Seq kuduColumns = seq;
            Seq sparkColumns = (Seq)kuduColumns.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(ColumnSchema col) {
                    DataType sparkType = SparkUtil$.MODULE$.kuduTypeToSparkType(col.getType(), col.getTypeAttributes());
                    return new StructField(col.getName(), sparkType, col.isNullable(), StructField$.MODULE$.apply$default$4());
                }
            }, Seq$.MODULE$.canBuildFrom());
            return StructType$.MODULE$.apply(sparkColumns);
        }
        throw new MatchError(option);
    }

    public Option<Seq<String>> sparkSchema$default$2() {
        return None$.MODULE$;
    }

    public Schema kuduSchema(StructType sparkSchema, Seq<String> keys) {
        ArrayList<ColumnSchema> kuduCols = new ArrayList<ColumnSchema>();
        keys.foreach((Function1)new Serializable(sparkSchema, kuduCols){
            public static final long serialVersionUID = 0L;
            private final StructType sparkSchema$1;
            private final ArrayList kuduCols$1;

            public final boolean apply(String key) {
                StructField field = this.sparkSchema$1.fields()[this.sparkSchema$1.fieldIndex(key)];
                ColumnSchema col = SparkUtil$.MODULE$.org$apache$kudu$spark$kudu$SparkUtil$$createColumnSchema(field, true);
                return this.kuduCols$1.add(col);
            }
            {
                this.sparkSchema$1 = sparkSchema$1;
                this.kuduCols$1 = kuduCols$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sparkSchema.fields()).filter((Function1)new Serializable(keys){
            public static final long serialVersionUID = 0L;
            private final Seq keys$1;

            public final boolean apply(StructField field) {
                return !this.keys$1.contains((Object)field.name());
            }
            {
                this.keys$1 = keys$1;
            }
        })).foreach((Function1)new Serializable(kuduCols){
            public static final long serialVersionUID = 0L;
            private final ArrayList kuduCols$1;

            public final boolean apply(StructField field) {
                ColumnSchema col = SparkUtil$.MODULE$.org$apache$kudu$spark$kudu$SparkUtil$$createColumnSchema(field, false);
                return this.kuduCols$1.add(col);
            }
            {
                this.kuduCols$1 = kuduCols$1;
            }
        });
        return new Schema(kuduCols);
    }

    public ColumnSchema org$apache$kudu$spark$kudu$SparkUtil$$createColumnSchema(StructField field, boolean isKey) {
        Object object;
        Type kt = this.sparkTypeToKuduType(field.dataType());
        ColumnSchema.ColumnSchemaBuilder col = new ColumnSchema.ColumnSchemaBuilder(field.name(), kt).key(isKey).nullable(field.nullable());
        Type type = kt;
        Type type2 = Type.DECIMAL;
        if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null)) {
            DecimalType dt = (DecimalType)field.dataType();
            object = col.typeAttributes(new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(dt.precision()).scale(dt.scale()).build());
        } else {
            object = BoxedUnit.UNIT;
        }
        return col.build();
    }

    private SparkUtil$() {
        MODULE$ = this;
    }
}

