/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Common;
import org.apache.kudu.shaded.com.google.common.base.Strings;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DecimalUtil {
    public static final int MAX_DECIMAL32_PRECISION = 9;
    public static final int MAX_UNSCALED_DECIMAL32 = 999999999;
    public static final int MIN_UNSCALED_DECIMAL32 = -999999999;
    public static final int DECIMAL32_SIZE = 4;
    public static final int MAX_DECIMAL64_PRECISION = 18;
    public static final long MAX_UNSCALED_DECIMAL64 = 999999999999999999L;
    public static final long MIN_UNSCALED_DECIMAL64 = -999999999999999999L;
    public static final int DECIMAL64_SIZE = 8;
    public static final int MAX_DECIMAL128_PRECISION = 38;
    public static final BigInteger MAX_UNSCALED_DECIMAL128 = new BigInteger(Strings.repeat("9", 38));
    public static final BigInteger MIN_UNSCALED_DECIMAL128 = MAX_UNSCALED_DECIMAL128.negate();
    public static final int DECIMAL128_SIZE = 16;
    public static final int MAX_DECIMAL_PRECISION = 38;

    public static int precisionToSize(int precision) {
        if (precision <= 9) {
            return 4;
        }
        if (precision <= 18) {
            return 8;
        }
        if (precision <= 38) {
            return 16;
        }
        throw new IllegalArgumentException("Unsupported decimal type precision: " + precision);
    }

    public static Common.DataType precisionToDataType(int precision) {
        if (precision <= 9) {
            return Common.DataType.DECIMAL32;
        }
        if (precision <= 18) {
            return Common.DataType.DECIMAL64;
        }
        if (precision <= 38) {
            return Common.DataType.DECIMAL128;
        }
        throw new IllegalArgumentException("Unsupported decimal type precision: " + precision);
    }

    public static BigDecimal maxValue(int precision, int scale) {
        String maxPrecision = Strings.repeat("9", precision);
        return new BigDecimal(new BigInteger(maxPrecision), scale);
    }

    public static BigDecimal minValue(int precision, int scale) {
        return DecimalUtil.maxValue(precision, scale).negate();
    }

    public static BigDecimal smallestValue(int scale) {
        return new BigDecimal(BigInteger.ONE, scale);
    }

    public static BigDecimal coerce(BigDecimal val, int targetPrecision, int targetScale) {
        if (val.scale() != targetScale) {
            try {
                val = val.setScale(targetScale, RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException ex) {
                throw new IllegalArgumentException("Value scale " + val.scale() + " can't be coerced to target scale " + targetScale + ". ");
            }
        }
        if (val.precision() > targetPrecision) {
            throw new IllegalArgumentException("Value precision " + val.precision() + " (after scale coercion) can't be coerced to target precision " + targetPrecision + ". ");
        }
        return val;
    }

    public static ColumnTypeAttributes typeAttributes(int precision, int scale) {
        return new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(precision).scale(scale).build();
    }
}

