/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.client.KuduRpcResponse;
import org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.shaded.com.google.common.base.Objects;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ListTablesResponse
extends KuduRpcResponse {
    private final List<TableInfo> tableInfosList;
    private final List<String> tablesList;

    ListTablesResponse(long elapsedMillis, String tsUUID, List<TableInfo> tableInfosList) {
        super(elapsedMillis, tsUUID);
        ArrayList<String> tablesList = new ArrayList<String>();
        for (TableInfo info : tableInfosList) {
            tablesList.add(info.getTableName());
        }
        this.tableInfosList = tableInfosList;
        this.tablesList = tablesList;
    }

    public List<String> getTablesList() {
        return this.tablesList;
    }

    public List<TableInfo> getTableInfosList() {
        return this.tableInfosList;
    }

    public static class TableInfo {
        private final String tableId;
        private final String tableName;

        TableInfo(String tableId, String tableName) {
            this.tableId = tableId;
            this.tableName = tableName;
        }

        public String getTableId() {
            return this.tableId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TableInfo)) {
                return false;
            }
            TableInfo tableInfo = (TableInfo)o;
            return Objects.equal(this.tableId, tableInfo.tableId) && Objects.equal(this.tableName, tableInfo.tableName);
        }

        public int hashCode() {
            return Objects.hashCode(this.tableId, this.tableName);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("tableId", this.tableId).add("tableName", this.tableName).toString();
        }
    }
}

