/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test.cluster;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kudu.Common;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.kudu.shaded.com.google.common.collect.Maps;
import org.apache.kudu.test.TempDirUtils;
import org.apache.kudu.test.cluster.KuduBinaryLocator;
import org.apache.kudu.tools.Tool;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MiniKuduCluster
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MiniKuduCluster.class);
    private Process miniCluster;
    private DataOutputStream miniClusterStdin;
    private DataInputStream miniClusterStdout;
    private Thread miniClusterErrorPrinter;
    private final Map<HostAndPort, DaemonInfo> masterServers = Maps.newHashMap();
    private final Map<HostAndPort, DaemonInfo> tabletServers = Maps.newHashMap();
    private final boolean enableKerberos;
    private final int numMasters;
    private final int numTservers;
    private final ImmutableList<String> extraTserverFlags;
    private final ImmutableList<String> extraMasterFlags;
    private final ImmutableList<String> locationInfo;
    private final String clusterRoot;
    private final String principal;
    private Tool.CreateClusterRequestPB.MiniKdcOptionsPB kdcOptionsPb;
    private final Common.HmsMode hmsMode;

    private MiniKuduCluster(boolean enableKerberos, int numMasters, int numTservers, List<String> extraTserverFlags, List<String> extraMasterFlags, List<String> locationInfo, Tool.CreateClusterRequestPB.MiniKdcOptionsPB kdcOptionsPb, String clusterRoot, Common.HmsMode hmsMode, String principal) {
        this.enableKerberos = enableKerberos;
        this.numMasters = numMasters;
        this.numTservers = numTservers;
        this.extraTserverFlags = ImmutableList.copyOf(extraTserverFlags);
        this.extraMasterFlags = ImmutableList.copyOf(extraMasterFlags);
        this.locationInfo = ImmutableList.copyOf(locationInfo);
        this.kdcOptionsPb = kdcOptionsPb;
        this.principal = principal;
        this.hmsMode = hmsMode;
        if (clusterRoot == null) {
            try {
                File tempRoot = TempDirUtils.makeTempDirectory("mini-kudu-cluster", TempDirUtils.DeleteOnExit.NO_DELETE_ON_EXIT);
                this.clusterRoot = tempRoot.toString();
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not create cluster root directory", ex);
            }
        } else {
            this.clusterRoot = clusterRoot;
        }
        Security.setProperty("jdk.certpath.disabledAlgorithms", "MD2, RC4, MD5");
        Security.setProperty("jdk.tls.disabledAlgorithms", "SSLv3, RC4, MD5");
    }

    private synchronized Tool.ControlShellResponsePB sendRequestToCluster(Tool.ControlShellRequestPB req) throws IOException {
        LOG.debug("Request: {}", (Object)req);
        this.miniClusterStdin.writeInt(req.getSerializedSize());
        this.miniClusterStdin.write(req.toByteArray());
        this.miniClusterStdin.flush();
        int respLength = this.miniClusterStdout.readInt();
        byte[] respBody = new byte[respLength];
        this.miniClusterStdout.readFully(respBody);
        Tool.ControlShellResponsePB resp = Tool.ControlShellResponsePB.parseFrom(respBody);
        LOG.debug("Response: {}", (Object)resp);
        if (resp.hasError()) {
            throw new IOException(resp.getError().getMessage());
        }
        return resp;
    }

    private synchronized void start() throws IOException {
        DaemonInfo d;
        Tool.ControlShellResponsePB resp;
        Preconditions.checkArgument(this.numMasters > 0, "Need at least one master");
        KuduBinaryLocator.ExecutableInfo exeInfo = KuduBinaryLocator.findBinary("kudu");
        ArrayList<String> commandLine = Lists.newArrayList(exeInfo.exePath(), "test", "mini_cluster", "--serialization=pb");
        LOG.info("Starting process: {}", commandLine);
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.environment().putAll(exeInfo.environment());
        this.miniCluster = processBuilder.start();
        this.miniClusterStdin = new DataOutputStream(this.miniCluster.getOutputStream());
        this.miniClusterStdout = new DataInputStream(this.miniCluster.getInputStream());
        ProcessInputStreamLogPrinterRunnable printer = new ProcessInputStreamLogPrinterRunnable(this.miniCluster.getErrorStream());
        this.miniClusterErrorPrinter = new Thread(printer);
        this.miniClusterErrorPrinter.setDaemon(true);
        this.miniClusterErrorPrinter.setName("cluster stderr printer");
        this.miniClusterErrorPrinter.start();
        Tool.CreateClusterRequestPB.Builder createClusterRequestBuilder = Tool.CreateClusterRequestPB.newBuilder().setNumMasters(this.numMasters).setNumTservers(this.numTservers).setEnableKerberos(this.enableKerberos).setHmsMode(this.hmsMode).addAllExtraMasterFlags(this.extraMasterFlags).addAllExtraTserverFlags(this.extraTserverFlags).setMiniKdcOptions(this.kdcOptionsPb).setClusterRoot(this.clusterRoot).setPrincipal(this.principal);
        if (!this.locationInfo.isEmpty()) {
            ArrayList<String> locationMappingCmd = new ArrayList<String>();
            locationMappingCmd.add(this.getClass().getResource("/assign-location.py").getFile());
            String locationMappingCmdPath = Paths.get(this.clusterRoot, "location-assignment.state").toString();
            locationMappingCmd.add("--state_store=" + locationMappingCmdPath);
            for (String location : this.locationInfo) {
                locationMappingCmd.add("--map " + location);
            }
            String string = "--location_mapping_cmd=" + Joiner.on(" ").join(locationMappingCmd);
            createClusterRequestBuilder.addExtraMasterFlags(string);
        }
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setCreateCluster(createClusterRequestBuilder.build()).build());
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setStartCluster(Tool.StartClusterRequestPB.newBuilder().build()).build());
        if (this.enableKerberos) {
            resp = this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setGetKdcEnvVars(Tool.GetKDCEnvVarsRequestPB.newBuilder().build()).build());
            for (Map.Entry entry : resp.getGetKdcEnvVars().getEnvVarsMap().entrySet()) {
                if (((String)entry.getKey()).equals("KRB5_CONFIG")) {
                    System.setProperty("java.security.krb5.conf", (String)entry.getValue());
                    continue;
                }
                if (!((String)entry.getKey()).equals("KRB5CCNAME")) continue;
                System.setProperty("kudu.krb5ccname", (String)entry.getValue());
            }
        }
        resp = this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setGetMasters(Tool.GetMastersRequestPB.newBuilder().build()).build());
        for (Tool.DaemonInfoPB daemonInfoPB : resp.getGetMasters().getMastersList()) {
            d = new DaemonInfo();
            d.id = daemonInfoPB.getId();
            d.isRunning = true;
            d.isPaused = false;
            this.masterServers.put(ProtobufHelper.hostAndPortFromPB(daemonInfoPB.getBoundRpcAddress()), d);
        }
        resp = this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setGetTservers(Tool.GetTServersRequestPB.newBuilder().build()).build());
        for (Tool.DaemonInfoPB daemonInfoPB : resp.getGetTservers().getTserversList()) {
            d = new DaemonInfo();
            d.id = daemonInfoPB.getId();
            d.isRunning = true;
            d.isPaused = false;
            this.tabletServers.put(ProtobufHelper.hostAndPortFromPB(daemonInfoPB.getBoundRpcAddress()), d);
        }
    }

    public String getMasterAddressesAsString() {
        return Joiner.on(',').join(this.masterServers.keySet());
    }

    public List<HostAndPort> getMasterServers() {
        return new ArrayList<HostAndPort>(this.masterServers.keySet());
    }

    public List<HostAndPort> getTabletServers() {
        return new ArrayList<HostAndPort>(this.tabletServers.keySet());
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void startMasterServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getMasterServer(hp);
        if (d.isRunning) {
            return;
        }
        LOG.info("Starting master server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setStartDaemon(Tool.StartDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isRunning = true;
    }

    public void killMasterServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getMasterServer(hp);
        if (!d.isRunning) {
            return;
        }
        LOG.info("Killing master server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setStopDaemon(Tool.StopDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isRunning = false;
    }

    public void pauseMasterServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getMasterServer(hp);
        if (d.isPaused) {
            return;
        }
        LOG.info("pausing master server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setPauseDaemon(Tool.PauseDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isPaused = true;
    }

    public void resumeMasterServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getMasterServer(hp);
        if (!d.isPaused) {
            return;
        }
        LOG.info("resuming master server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setResumeDaemon(Tool.ResumeDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isPaused = false;
    }

    public void startTabletServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getTabletServer(hp);
        if (d.isRunning) {
            return;
        }
        LOG.info("Starting tablet server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setStartDaemon(Tool.StartDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isRunning = true;
    }

    public void killTabletServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getTabletServer(hp);
        if (!d.isRunning) {
            return;
        }
        LOG.info("Killing tablet server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setStopDaemon(Tool.StopDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isRunning = false;
    }

    public void pauseTabletServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getTabletServer(hp);
        if (d.isPaused) {
            return;
        }
        LOG.info("pausing tablet server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setPauseDaemon(Tool.PauseDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isPaused = true;
    }

    public void resumeTabletServer(HostAndPort hp) throws IOException {
        DaemonInfo d = this.getTabletServer(hp);
        if (!d.isPaused) {
            return;
        }
        LOG.info("resuming tablet server {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setResumeDaemon(Tool.ResumeDaemonRequestPB.newBuilder().setId(d.id).build()).build());
        d.isPaused = true;
    }

    public void killAllMasterServers() throws IOException {
        for (Map.Entry<HostAndPort, DaemonInfo> e : this.masterServers.entrySet()) {
            this.killMasterServer(e.getKey());
        }
    }

    public void startAllMasterServers() throws IOException {
        for (Map.Entry<HostAndPort, DaemonInfo> e : this.masterServers.entrySet()) {
            this.startMasterServer(e.getKey());
        }
    }

    public void killAllTabletServers() throws IOException {
        for (Map.Entry<HostAndPort, DaemonInfo> e : this.tabletServers.entrySet()) {
            this.killTabletServer(e.getKey());
        }
    }

    public void startAllTabletServers() throws IOException {
        for (Map.Entry<HostAndPort, DaemonInfo> e : this.tabletServers.entrySet()) {
            this.startTabletServer(e.getKey());
        }
    }

    public void setMasterFlag(HostAndPort hp, String flag, String value) throws IOException {
        DaemonInfo d = this.getMasterServer(hp);
        LOG.info("Setting flag for master at {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setSetDaemonFlag(Tool.SetDaemonFlagRequestPB.newBuilder().setId(d.id).setFlag(flag).setValue(value).build()).build());
    }

    public void setTServerFlag(HostAndPort hp, String flag, String value) throws IOException {
        DaemonInfo d = this.getTabletServer(hp);
        LOG.info("Setting flag for tserver at {}", (Object)hp);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setSetDaemonFlag(Tool.SetDaemonFlagRequestPB.newBuilder().setId(d.id).setFlag(flag).setValue(value).build()).build());
    }

    public void kdestroy() throws IOException {
        LOG.info("Destroying all Kerberos credentials");
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setKdestroy(Tool.KdestroyRequestPB.getDefaultInstance()).build());
    }

    public void kinit(String username) throws IOException {
        LOG.info("Running kinit for user {}", (Object)username);
        this.sendRequestToCluster(Tool.ControlShellRequestPB.newBuilder().setKinit(Tool.KinitRequestPB.newBuilder().setUsername(username).build()).build());
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public synchronized void shutdown() {
        if (this.miniClusterStdin != null) {
            try {
                this.miniClusterStdin.close();
            }
            catch (IOException e) {
                LOG.info("Caught exception while closing minicluster stdin", (Throwable)e);
            }
        }
        if (this.miniClusterStdout != null) {
            try {
                this.miniClusterStdout.close();
            }
            catch (IOException e) {
                LOG.info("Caught exception while closing minicluster stdout", (Throwable)e);
            }
        }
        if (this.miniClusterErrorPrinter != null) {
            try {
                this.miniClusterErrorPrinter.join();
            }
            catch (InterruptedException e) {
                LOG.info("Caught exception while closing minicluster stderr", (Throwable)e);
            }
        }
        if (this.miniCluster != null) {
            try {
                this.miniCluster.waitFor();
            }
            catch (InterruptedException e) {
                LOG.warn("Minicluster process did not exit, destroying");
                this.miniCluster.destroy();
            }
        }
    }

    private DaemonInfo getMasterServer(HostAndPort hp) throws RuntimeException {
        DaemonInfo d = this.masterServers.get(hp);
        if (d == null) {
            throw new RuntimeException(String.format("Master server %s not found", hp));
        }
        return d;
    }

    private DaemonInfo getTabletServer(HostAndPort hp) throws RuntimeException {
        DaemonInfo d = this.tabletServers.get(hp);
        if (d == null) {
            throw new RuntimeException(String.format("Tablet server %s not found", hp));
        }
        return d;
    }

    public String getClusterRoot() {
        return this.clusterRoot;
    }

    public static class MiniKuduClusterBuilder {
        private int numMasterServers = 1;
        private int numTabletServers = 3;
        private boolean enableKerberos = false;
        private final List<String> extraTabletServerFlags = new ArrayList<String>();
        private final List<String> extraMasterServerFlags = new ArrayList<String>();
        private final List<String> locationInfo = new ArrayList<String>();
        private String clusterRoot = null;
        private String principal = "kudu";
        private Tool.CreateClusterRequestPB.MiniKdcOptionsPB.Builder kdcOptionsPb = Tool.CreateClusterRequestPB.MiniKdcOptionsPB.newBuilder();
        private Common.HmsMode hmsMode = Common.HmsMode.NONE;

        public MiniKuduClusterBuilder numMasterServers(int numMasterServers) {
            this.numMasterServers = numMasterServers;
            return this;
        }

        public MiniKuduClusterBuilder numTabletServers(int numTabletServers) {
            this.numTabletServers = numTabletServers;
            return this;
        }

        public MiniKuduClusterBuilder enableKerberos() {
            this.enableKerberos = true;
            return this;
        }

        public MiniKuduClusterBuilder enableHiveMetastoreIntegration() {
            this.hmsMode = Common.HmsMode.ENABLE_METASTORE_INTEGRATION;
            return this;
        }

        public MiniKuduClusterBuilder addTabletServerFlag(String flag) {
            this.extraTabletServerFlags.add(flag);
            return this;
        }

        public MiniKuduClusterBuilder addMasterServerFlag(String flag) {
            this.extraMasterServerFlags.add(flag);
            return this;
        }

        public MiniKuduClusterBuilder addLocation(String location) {
            this.locationInfo.add(location);
            return this;
        }

        public MiniKuduClusterBuilder kdcTicketLifetime(String lifetime) {
            this.kdcOptionsPb.setTicketLifetime(lifetime);
            return this;
        }

        public MiniKuduClusterBuilder kdcRenewLifetime(String lifetime) {
            this.kdcOptionsPb.setRenewLifetime(lifetime);
            return this;
        }

        public MiniKuduClusterBuilder clusterRoot(String clusterRoot) {
            this.clusterRoot = clusterRoot;
            return this;
        }

        public MiniKuduClusterBuilder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public MiniKuduCluster build() throws IOException {
            MiniKuduCluster cluster = new MiniKuduCluster(this.enableKerberos, this.numMasterServers, this.numTabletServers, this.extraTabletServerFlags, this.extraMasterServerFlags, this.locationInfo, this.kdcOptionsPb.build(), this.clusterRoot, this.hmsMode, this.principal);
            try {
                cluster.start();
            }
            catch (IOException e) {
                cluster.close();
                throw e;
            }
            return cluster;
        }
    }

    public static class ProcessInputStreamLogPrinterRunnable
    implements Runnable {
        private final InputStream is;

        public ProcessInputStreamLogPrinterRunnable(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            block3: {
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(this.is, StandardCharsets.UTF_8));
                    while ((line = in.readLine()) != null) {
                        LOG.info(line);
                    }
                    in.close();
                }
                catch (Exception e) {
                    if (e.getMessage().contains("Stream closed")) break block3;
                    LOG.error("Caught error while reading a process' output", (Throwable)e);
                }
            }
        }
    }

    private static class DaemonInfo {
        Tool.DaemonIdentifierPB id;
        boolean isRunning;
        boolean isPaused;

        private DaemonInfo() {
        }
    }
}

