/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.binder.grpc;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.function.Consumer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Counter;

class MetricCollectingClientCallListener<A>
extends ForwardingClientCallListener.SimpleForwardingClientCallListener<A> {
    private final Counter responseCounter;
    private final Consumer<Status.Code> processingDurationTiming;

    public MetricCollectingClientCallListener(ClientCall.Listener<A> delegate, Counter responseCounter, Consumer<Status.Code> processingDurationTiming) {
        super(delegate);
        this.responseCounter = responseCounter;
        this.processingDurationTiming = processingDurationTiming;
    }

    public void onClose(Status status, Metadata metadata) {
        this.processingDurationTiming.accept(status.getCode());
        super.onClose(status, metadata);
    }

    public void onMessage(A responseMessage) {
        this.responseCounter.increment();
        super.onMessage(responseMessage);
    }
}

