/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.kudu.client.KuduMetrics;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.junit.Assert;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MetricTestUtils {
    public static long totalRequestCount() {
        return (long)KuduMetrics.totalCount(KuduMetrics.RPC_REQUESTS_METRIC);
    }

    public static <T> T validateRequestCount(int expectedCount, String clientId, Callable<T> f) throws Exception {
        return MetricTestUtils.validateRequestCount(expectedCount, clientId, Collections.emptyList(), f);
    }

    public static <T> T validateRequestCount(int expectedCount, String clientId, String rpcMethodName, Callable<T> f) throws Exception {
        return MetricTestUtils.validateRequestCount(expectedCount, clientId, Collections.singletonList(rpcMethodName), f);
    }

    public static <T> T validateRequestCount(int expectedCount, String clientId, List<String> rpcMethodNames, Callable<T> f) throws Exception {
        HashMap<String, Long> beforeMap = new HashMap<String, Long>();
        for (String rpcMethodName : rpcMethodNames) {
            beforeMap.put(rpcMethodName, (long)KuduMetrics.totalCount(KuduMetrics.RPC_REQUESTS_METRIC, "client.id", clientId, "method.name", rpcMethodName));
        }
        T t2 = f.call();
        long count = 0L;
        for (Map.Entry entry : beforeMap.entrySet()) {
            String rpcMethodName = (String)entry.getKey();
            long before = (Long)entry.getValue();
            long after = (long)KuduMetrics.totalCount(KuduMetrics.RPC_REQUESTS_METRIC, "client.id", clientId, "method.name", rpcMethodName);
            count += after - before;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
        return t2;
    }
}

