/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime;

import java.io.Serializable;
import java.util.Locale;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.kylin.engine.spark.cross.CrossDateTimeUtils$;
import org.apache.kylin.query.exception.UnsupportedSparkFunctionException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.KylinFunctions$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IfNull;
import org.apache.spark.sql.catalyst.expressions.StringLocate;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ExpressionConverter$ {
    public static ExpressionConverter$ MODULE$;
    private final HashSet<String> unaryParameterFunc;
    private final HashSet<String> ternaryParameterFunc;
    private final HashSet<String> binaryParameterFunc;
    private final HashSet<String> noneParameterfunc;
    private final HashSet<String> varArgsFunc;

    static {
        new ExpressionConverter$();
    }

    public HashSet<String> unaryParameterFunc() {
        return this.unaryParameterFunc;
    }

    public HashSet<String> ternaryParameterFunc() {
        return this.ternaryParameterFunc;
    }

    public HashSet<String> binaryParameterFunc() {
        return this.binaryParameterFunc;
    }

    public HashSet<String> noneParameterfunc() {
        return this.noneParameterfunc;
    }

    public HashSet<String> varArgsFunc() {
        return this.varArgsFunc;
    }

    public Object convert(SqlTypeName sqlTypeName, RelDataType relDataType, SqlKind op, String opName, Seq<Object> children) {
        Column column;
        SqlKind sqlKind = op;
        if (SqlKind.IS_NULL.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            column = KylinFunctions$.MODULE$.k_lit(children.head()).isNull();
        } else if (SqlKind.IS_NOT_NULL.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            column = KylinFunctions$.MODULE$.k_lit(children.head()).isNotNull();
        } else if (SqlKind.LIKE.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 2);
            column = KylinFunctions$.MODULE$.k_like(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.last()));
        } else if (SqlKind.MINUS_PREFIX.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            column = functions$.MODULE$.negate(KylinFunctions$.MODULE$.k_lit(children.head()));
        } else if (SqlKind.IN.equals(sqlKind)) {
            Seq values = (Seq)((TraversableLike)children.drop(1)).map((Function1 & Serializable & scala.Serializable)c -> KylinFunctions$.MODULE$.k_lit(c).expr(), Seq$.MODULE$.canBuildFrom());
            column = KylinFunctions$.MODULE$.in(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), values);
        } else if (SqlKind.NOT_IN.equals(sqlKind)) {
            Seq values = (Seq)((TraversableLike)children.drop(1)).map((Function1 & Serializable & scala.Serializable)c -> KylinFunctions$.MODULE$.k_lit(c).expr(), Seq$.MODULE$.canBuildFrom());
            column = functions$.MODULE$.not(KylinFunctions$.MODULE$.in(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), values));
        } else if (SqlKind.DIVIDE.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 2);
            column = KylinFunctions$.MODULE$.k_lit(children.head()).divide((Object)KylinFunctions$.MODULE$.k_lit(children.last()));
        } else if (SqlKind.CASE.equals(sqlKind)) {
            Seq evens = (Seq)((TraversableLike)((TraversableLike)children.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$convert$3(p)))).map((Function1 & Serializable & scala.Serializable)p -> KylinFunctions$.MODULE$.k_lit(p._1()), Seq$.MODULE$.canBuildFrom());
            Seq odds = (Seq)((TraversableLike)((TraversableLike)children.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$convert$5(p)))).map((Function1 & Serializable & scala.Serializable)p -> KylinFunctions$.MODULE$.k_lit(p._1()), Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.assert(evens.length() == odds.length() + 1);
            Seq zip = (Seq)evens.zip((GenIterable)odds, Seq$.MODULE$.canBuildFrom());
            ObjectRef column2 = ObjectRef.create(null);
            if (zip.nonEmpty()) {
                column2.elem = functions$.MODULE$.when((Column)((Tuple2)zip.head())._1(), ((Tuple2)zip.head())._2());
                ((IterableLike)zip.drop(1)).foreach((Function1 & Serializable & scala.Serializable)p -> {
                    column2.elem = ((Column)column2.elem).when((Column)p._1(), p._2());
                    return BoxedUnit.UNIT;
                });
            }
            column = ((Column)column2.elem).otherwise(evens.last());
        } else if (SqlKind.EXTRACT.equals(sqlKind)) {
            Column column3;
            String timeUnit = (String)children.head();
            Object inputAsTS = children.apply(1);
            String string = timeUnit;
            if ("YEAR".equals(string)) {
                column3 = functions$.MODULE$.year(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("QUARTER".equals(string)) {
                column3 = functions$.MODULE$.quarter(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("MONTH".equals(string)) {
                column3 = functions$.MODULE$.month(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("WEEK".equals(string)) {
                column3 = functions$.MODULE$.weekofyear(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("DOY".equals(string)) {
                column3 = functions$.MODULE$.dayofyear(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("DAY".equals(string)) {
                column3 = functions$.MODULE$.dayofmonth(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("DOW".equals(string)) {
                column3 = KylinFunctions$.MODULE$.kylin_day_of_week(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("HOUR".equals(string)) {
                column3 = functions$.MODULE$.hour(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("MINUTE".equals(string)) {
                column3 = functions$.MODULE$.minute(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("SECOND".equals(string)) {
                column3 = functions$.MODULE$.second(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            } else {
                throw new UnsupportedSparkFunctionException(new StringBuilder(21).append("Unsupported function ").append(timeUnit).toString());
            }
            column = column3;
        } else if (SqlKind.REINTERPRET.equals(sqlKind)) {
            column = KylinFunctions$.MODULE$.k_lit(children.head());
        } else if (SqlKind.CAST.equals(sqlKind)) {
            DataType goalType = SparkTypeUtil$.MODULE$.convertSqlTypeToSparkType(relDataType);
            column = KylinFunctions$.MODULE$.k_lit(children.head()).cast(goalType);
        } else if (SqlKind.TRIM.equals(sqlKind)) {
            Column column4;
            if (children.length() == 3) {
                Column column5;
                Object object = children.head();
                if ("TRAILING".equals(object)) {
                    column5 = functions$.MODULE$.rtrim(KylinFunctions$.MODULE$.k_lit(children.last()));
                } else if ("LEADING".equals(object)) {
                    column5 = functions$.MODULE$.ltrim(KylinFunctions$.MODULE$.k_lit(children.last()));
                } else if ("BOTH".equals(object)) {
                    column5 = functions$.MODULE$.trim(KylinFunctions$.MODULE$.k_lit(children.last()));
                } else {
                    throw new MatchError(object);
                }
                column4 = column5;
            } else {
                column4 = functions$.MODULE$.trim(KylinFunctions$.MODULE$.k_lit(children.head()));
            }
            column = column4;
        } else if (SqlKind.OTHER.equals(sqlKind)) {
            String funcName = opName.toLowerCase(Locale.ROOT);
            String string = funcName;
            if (!"||".equals(string)) {
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unsupported function ").append(funcName).toString());
            }
            Column column6 = functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1))}));
            column = column6;
        } else if (SqlKind.OTHER_FUNCTION.equals(sqlKind)) {
            Column column7;
            String funcName = opName.toLowerCase(Locale.ROOT);
            String string = funcName;
            if ("abs".equals(string)) {
                column7 = functions$.MODULE$.abs(KylinFunctions$.MODULE$.k_lit(children.head()).cast(SparkTypeUtil$.MODULE$.convertSqlTypeToSparkType(relDataType)));
            } else if ("round".equals(string)) {
                column7 = functions$.MODULE$.round(KylinFunctions$.MODULE$.k_lit(children.head()), BoxesRunTime.unboxToInt((Object)children.apply(1)));
            } else if ("truncate".equals(string)) {
                column7 = KylinFunctions$.MODULE$.kylin_truncate(KylinFunctions$.MODULE$.k_lit(children.head()), BoxesRunTime.unboxToInt((Object)children.apply(1)));
            } else if ("cot".equals(string)) {
                column7 = KylinFunctions$.MODULE$.k_lit((Object)BoxesRunTime.boxToInteger((int)1)).divide((Object)functions$.MODULE$.tan(KylinFunctions$.MODULE$.k_lit(children.head())));
            } else if ("isnull".equals(string)) {
                column7 = functions$.MODULE$.isnull(KylinFunctions$.MODULE$.k_lit(children.head()));
            } else if ("ifnull".equals(string)) {
                column7 = new Column((Expression)new IfNull(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr()));
            } else if ("lower".equals(string)) {
                column7 = functions$.MODULE$.lower(KylinFunctions$.MODULE$.k_lit(children.head()));
            } else if ("upper".equals(string)) {
                column7 = functions$.MODULE$.upper(KylinFunctions$.MODULE$.k_lit(children.head()));
            } else if ("char_length".equals(string)) {
                column7 = functions$.MODULE$.length(KylinFunctions$.MODULE$.k_lit(children.head()));
            } else if ("character_length".equals(string)) {
                column7 = functions$.MODULE$.length(KylinFunctions$.MODULE$.k_lit(children.head()));
            } else if ("replace ".equals(string)) {
                column7 = functions$.MODULE$.regexp_replace(KylinFunctions$.MODULE$.k_lit(children.head()), (String)children.apply(1), (String)children.apply(2));
            } else {
                boolean bl = "substring".equals(string) ? true : "substr".equals(string);
                if (bl) {
                    Column column8;
                    if (children.length() == 3) {
                        column8 = KylinFunctions$.MODULE$.k_lit(children.head()).substr(KylinFunctions$.MODULE$.k_lit(children.apply(1)), KylinFunctions$.MODULE$.k_lit(children.apply(2)));
                    } else if (children.length() == 2) {
                        column8 = KylinFunctions$.MODULE$.k_lit(children.head()).substr(KylinFunctions$.MODULE$.k_lit(children.apply(1)), KylinFunctions$.MODULE$.k_lit((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
                    } else {
                        throw new UnsupportedOperationException("substring must provide three or two parameters under sparder");
                    }
                    column7 = column8;
                } else if ("initcapb".equals(string)) {
                    column7 = functions$.MODULE$.initcap(KylinFunctions$.MODULE$.k_lit(children.head()));
                } else if ("instr".equals(string)) {
                    int instr = children.length() == 2 ? 1 : BoxesRunTime.unboxToInt((Object)children.apply(2));
                    column7 = new Column((Expression)new StringLocate(KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), KylinFunctions$.MODULE$.k_lit(children.head()).expr(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)instr)).expr()));
                } else if ("length".equals(string)) {
                    column7 = functions$.MODULE$.length(KylinFunctions$.MODULE$.k_lit(children.head()));
                } else if ("strpos".equals(string)) {
                    int pos = children.length() == 2 ? 1 : BoxesRunTime.unboxToInt((Object)children.apply(2));
                    column7 = new Column((Expression)new StringLocate(KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), KylinFunctions$.MODULE$.k_lit(children.head()).expr(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)pos)).expr()));
                } else if ("position".equals(string)) {
                    int pos = children.length() == 2 ? 1 : BoxesRunTime.unboxToInt((Object)children.apply(2));
                    column7 = new Column((Expression)new StringLocate(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)pos)).expr()));
                } else if ("concat".equals(string)) {
                    column7 = functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1))}));
                } else if ("concat_ws".equals(string)) {
                    column7 = functions$.MODULE$.concat_ws(children.head().toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.apply(1))}));
                } else if ("split_part".equals(string)) {
                    Column[] args = (Column[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), functions$.MODULE$.lit(children.apply(1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)children.apply(2))))}))).toArray(ClassTag$.MODULE$.apply(Column.class));
                    column7 = functions$.MODULE$.callUDF("split_part", (Seq)Predef$.MODULE$.wrapRefArray((Object[])args));
                } else if ("current_date".equals(string)) {
                    column7 = KylinFunctions$.MODULE$.k_lit((Object)CrossDateTimeUtils$.MODULE$.dateToString());
                } else if ("current_timestamp".equals(string)) {
                    column7 = functions$.MODULE$.current_timestamp();
                } else if ("to_timestamp".equals(string)) {
                    Column column9;
                    if (children.length() == 1) {
                        column9 = functions$.MODULE$.to_timestamp(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if (children.length() == 2) {
                        column9 = functions$.MODULE$.to_timestamp(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString());
                    } else {
                        throw new UnsupportedOperationException("to_timestamp must provide one or two parameters under sparder");
                    }
                    column7 = column9;
                } else if ("unix_timestamp".equals(string)) {
                    Column column10;
                    if (children.length() == 0) {
                        column10 = functions$.MODULE$.unix_timestamp();
                    } else if (children.length() == 1) {
                        column10 = functions$.MODULE$.unix_timestamp(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if (children.length() == 2) {
                        column10 = functions$.MODULE$.unix_timestamp(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString());
                    } else {
                        throw new UnsupportedOperationException("unix_timestamp only supports two or fewer parameters");
                    }
                    column7 = column10;
                } else if ("to_date".equals(string)) {
                    Column column11;
                    if (children.length() == 1) {
                        column11 = functions$.MODULE$.to_date(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if (children.length() == 2) {
                        column11 = functions$.MODULE$.to_date(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString());
                    } else {
                        throw new UnsupportedOperationException("to_date must provide one or two parameters under sparder");
                    }
                    column7 = column11;
                } else {
                    boolean bl2 = "to_char".equals(string) ? true : "date_format".equals(string);
                    if (bl2) {
                        String string2 = KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString().toUpperCase(Locale.ROOT);
                        String string3 = "YEAR".equals(string2) ? "y" : ("MONTH".equals(string2) ? "M" : ("DAY".equals(string2) ? "d" : ("HOUR".equals(string2) ? "h" : ("MINUTE".equals(string2) ? "m" : ("MINUTES".equals(string2) ? "m" : ("SECOND".equals(string2) ? "s" : ("SECONDS".equals(string2) ? "s" : KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString())))))));
                        String part = string3;
                        column7 = functions$.MODULE$.date_format(KylinFunctions$.MODULE$.k_lit(children.head()), part);
                    } else if ("power".equals(string)) {
                        column7 = functions$.MODULE$.pow(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)));
                    } else if ("log10".equals(string)) {
                        column7 = functions$.MODULE$.log10(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("ln".equals(string)) {
                        column7 = functions$.MODULE$.log(Math.E, KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("exp".equals(string)) {
                        column7 = functions$.MODULE$.exp(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("acos".equals(string)) {
                        column7 = functions$.MODULE$.acos(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("asin".equals(string)) {
                        column7 = functions$.MODULE$.asin(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("atan".equals(string)) {
                        column7 = functions$.MODULE$.atan(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("atan2".equals(string)) {
                        Predef$.MODULE$.assert(children.size() == 2);
                        column7 = functions$.MODULE$.atan2(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.last()));
                    } else if ("cos".equals(string)) {
                        column7 = functions$.MODULE$.cos(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("degrees".equals(string)) {
                        column7 = functions$.MODULE$.degrees(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("radians".equals(string)) {
                        column7 = functions$.MODULE$.radians(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("sign".equals(string)) {
                        column7 = functions$.MODULE$.signum(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("tan".equals(string)) {
                        column7 = functions$.MODULE$.tan(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if ("sin".equals(string)) {
                        column7 = functions$.MODULE$.sin(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else if (this.noneParameterfunc().contains((Object)string)) {
                        column7 = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
                    } else if (this.unaryParameterFunc().contains((Object)string)) {
                        column7 = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head())}));
                    } else if (this.binaryParameterFunc().contains((Object)string)) {
                        column7 = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1))}));
                    } else if (this.ternaryParameterFunc().contains((Object)string)) {
                        column7 = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)), KylinFunctions$.MODULE$.k_lit(children.apply(2))}));
                    } else if (this.varArgsFunc().contains((Object)string)) {
                        column7 = functions$.MODULE$.callUDF(string, (Seq)children.map((Function1 & Serializable & scala.Serializable)x$1 -> KylinFunctions$.MODULE$.k_lit(x$1), Seq$.MODULE$.canBuildFrom()));
                    } else {
                        boolean bl3 = "date_part".equals(string) ? true : "date_trunc".equals(string);
                        if (bl3) {
                            String string4 = KylinFunctions$.MODULE$.k_lit(children.head()).toString().toUpperCase(Locale.ROOT);
                            String string5 = "YEAR".equals(string4) ? "y" : ("MONTH".equals(string4) ? "M" : ("DAY".equals(string4) ? "d" : ("HOUR".equals(string4) ? "h" : ("MINUTE".equals(string4) ? "m" : ("MINUTES".equals(string4) ? "m" : ("SECOND".equals(string4) ? "s" : ("SECONDS".equals(string4) ? "s" : KylinFunctions$.MODULE$.k_lit(children.head()).toString())))))));
                            String part = string5;
                            column7 = functions$.MODULE$.date_format(KylinFunctions$.MODULE$.k_lit(children.apply(1)), part);
                        } else if ("datediff".equals(string)) {
                            column7 = functions$.MODULE$.datediff(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)));
                        } else if ("initcap".equals(string)) {
                            column7 = functions$.MODULE$.initcap(KylinFunctions$.MODULE$.k_lit(children.head()));
                        } else if ("pi".equals(string)) {
                            column7 = KylinFunctions$.MODULE$.k_lit((Object)BoxesRunTime.boxToDouble((double)Math.PI));
                        } else {
                            boolean bl4 = "regexp_like".equals(string) ? true : "rlike".equals(string);
                            if (bl4) {
                                column7 = KylinFunctions$.MODULE$.k_lit(children.head()).rlike(children.apply(1).toString());
                            } else if ("if".equals(string)) {
                                column7 = new Column((Expression)new If(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(2)).expr()));
                            } else {
                                throw new UnsupportedOperationException(new StringBuilder(21).append("Unsupported function ").append(funcName).toString());
                            }
                        }
                    }
                }
            }
            column = column7;
        } else if (SqlKind.CEIL.equals(sqlKind)) {
            column = functions$.MODULE$.ceil(KylinFunctions$.MODULE$.k_lit(children.head()));
        } else if (SqlKind.FLOOR.equals(sqlKind)) {
            column = functions$.MODULE$.floor(KylinFunctions$.MODULE$.k_lit(children.head()));
        } else if (SqlKind.ARRAY_VALUE_CONSTRUCTOR.equals(sqlKind)) {
            column = functions$.MODULE$.array((Seq)children.map((Function1 & Serializable & scala.Serializable)child -> KylinFunctions$.MODULE$.k_lit((Object)child.toString()), Seq$.MODULE$.canBuildFrom()));
        } else {
            throw new UnsupportedOperationException(sqlKind.toString());
        }
        return column;
    }

    public static final /* synthetic */ boolean $anonfun$convert$3(Tuple2 p) {
        return p._2$mcI$sp() % 2 == 0;
    }

    public static final /* synthetic */ boolean $anonfun$convert$5(Tuple2 p) {
        return p._2$mcI$sp() % 2 == 1;
    }

    private ExpressionConverter$() {
        MODULE$ = this;
        this.unaryParameterFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ucase", "lcase", "base64", "sentences", "unbase64", "crc32", "md5", "sha", "sha1", "weekofyear", "cbrt", "cosh", "expm1", "factorial", "log1p", "log2", "rint", "sinh", "tanh"}));
        this.ternaryParameterFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replace", "substring_index", "lpad", "rpad", "conv"}));
        this.binaryParameterFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decode", "encode", "find_in_set", "levenshtein", "sha2", "trunc", "add_months", "date_add", "date_sub", "from_unixtime", "from_utc_timestamp", "to_utc_timestamp", "bround", "hypot", "log"}));
        this.noneParameterfunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_database", "input_file_block_length", "input_file_block_start", "input_file_name", "monotonically_increasing_id", "now", "spark_partition_id", "uuid"}));
        this.varArgsFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"months_between", "locate", "rtrim"}));
    }
}

