/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api;

import org.apache.lens.api.LensException;

public final class LensConfConstants {
    public static final String SERVER_PFX = "lens.server.";
    public static final String QUERY_PFX = "lens.query.";
    public static final String SESSION_PFX = "lens.session.";
    public static final String METASTORE_PFX = "lens.metastore.";
    public static final String DRIVER_CLASSES = "lens.server.drivers";
    public static final String SERVICE_NAMES = "lens.server.servicenames";
    public static final String WS_RESOURCE_NAMES = "lens.server.ws.resourcenames";
    public static final String WS_LISTENER_NAMES = "lens.server.ws.listenernames";
    public static final String WS_FILTER_NAMES = "lens.server.ws.filternames";
    public static final String WS_FEATURE_NAMES = "lens.server.ws.featurenames";
    public static final String SERVICE_IMPL_SFX = ".service.impl";
    public static final String WS_RESOURCE_IMPL_SFX = ".ws.resource.impl";
    public static final String WS_FEATURE_IMPL_SFX = ".ws.feature.impl";
    public static final String WS_LISTENER_IMPL_SFX = ".ws.listener.impl";
    public static final String WS_FILTER_IMPL_SFX = ".ws.filter.impl";
    public static final String QUERY_STATE_LOGGER_ENABLED = "lens.server.query.state.logger.enabled";
    public static final String EVENT_SERVICE_THREAD_POOL_SIZE = "lens.server.event.service.thread.pool.size";
    public static final String SERVER_BASE_URL = "lens.server.base.url";
    public static final String DEFAULT_SERVER_BASE_URL = "http://0.0.0.0:9999/lensapi";
    public static final String SERVER_RESTART_ENABLED = "lens.server.restart.enabled";
    public static final boolean DEFAULT_SERVER_RESTART_ENABLED = true;
    public static final String SERVER_STATE_PERSIST_LOCATION = "lens.server.persist.location";
    public static final String DEFAULT_SERVER_STATE_PERSIST_LOCATION = "file:///tmp/lensserver";
    public static final String SERVER_RECOVER_ON_RESTART = "lens.server.recover.onrestart";
    public static final boolean DEFAULT_SERVER_RECOVER_ON_RESTART = true;
    public static final String SESSION_TIMEOUT_SECONDS = "lens.server.session.timeout.seconds";
    public static final long SESSION_TIMEOUT_SECONDS_DEFAULT = 86400L;
    public static final String SERVER_UI_URI = "lens.server.ui.base.uri";
    public static final String DEFAULT_SERVER_UI_URI = "http://0.0.0.0:19999/";
    public static final String SERVER_UI_STATIC_DIR = "lens.server..ui.static.dir";
    public static final String DEFAULT_SERVER_UI_STATIC_DIR = "webapp/lens-server/static";
    public static final String SERVER_UI_ENABLE_CACHING = "lens.server.ui.enable.caching";
    public static final boolean DEFAULT_SERVER_UI_ENABLE_CACHING = true;
    public static final String SERVER_SNAPSHOT_INTERVAL = "lens.server.snapshot.interval";
    public static final long DEFAULT_SERVER_SNAPSHOT_INTERVAL = 300000L;
    public static final String QUERY_MAIL_NOTIFY = "lens.query.enable.mail.notify";
    public static final String WHETHER_MAIL_NOTIFY_DEFAULT = "false";
    public static final String MAIL_FROM_ADDRESS = "lens.server.mail.from.address";
    public static final String MAIL_HOST = "lens.server.mail.host";
    public static final String MAIL_PORT = "lens.server.mail.port";
    public static final String MAIL_SMTP_TIMEOUT = "lens.server.mail.smtp.timeout";
    public static final String MAIL_DEFAULT_SMTP_TIMEOUT = "30000";
    public static final String MAIL_SMTP_CONNECTIONTIMEOUT = "lens.server.mail.smtp.connectiontimeout";
    public static final String MAIL_DEFAULT_SMTP_CONNECTIONTIMEOUT = "15000";
    public static final String QUERY_RESULT_EMAIL_CC = "lens.query.result.email.cc";
    public static final String QUERY_RESULT_DEFAULT_EMAIL_CC = "";
    public static final String SESSION_CLUSTER_USER = "lens.session.cluster.user";
    public static final String MAPRED_JOB_QUEUE_NAME = "mapred.job.queue.name";
    public static final String SESSION_LOGGEDIN_USER = "lens.session.loggedin.user";
    public static final String USER_RESOLVER_TYPE = "lens.server.user.resolver.type";
    public static final String USER_RESOLVER_FIXED_VALUE = "lens.server.user.resolver.fixed.value";
    public static final String USER_RESOLVER_PROPERTYBASED_FILENAME = "lens.server.user.resolver.propertybased.filename";
    public static final String USER_RESOLVER_DB_KEYS = "lens.server.user.resolver.db.keys";
    public static final String USER_RESOLVER_DB_QUERY = "lens.server.user.resolver.db.query";
    public static final String USER_RESOLVER_CUSTOM_CLASS = "lens.server.user.resolver.custom.class";
    public static final String USER_RESOLVER_CACHE_EXPIRY = "lens.server.user.resolver.cache.expiry";
    public static final String USER_RESOLVER_CACHE_MAX_SIZE = "lens.server.user.resolver.cache.max_size";
    public static final String USER_RESOLVER_LDAP_URL = "lens.server.user.resolver.ldap.url";
    public static final String USER_RESOLVER_LDAP_INTERMEDIATE_DB_QUERY = "lens.server.user.resolver.ldap.intermediate.db.query";
    public static final String USER_RESOLVER_LDAP_FIELDS = "lens.server.user.resolver.ldap.fields";
    public static final String USER_RESOLVER_LDAP_INTERMEDIATE_DB_INSERT_SQL = "lens.server.user.resolver.ldap.intermediate.db.insert.sql";
    public static final String USER_RESOLVER_LDAP_INTERMEDIATE_DB_DELETE_SQL = "lens.server.user.resolver.ldap.intermediate.db.delete.sql";
    public static final String USER_RESOLVER_LDAP_BIND_DN = "lens.server.user.resolver.ldap.bind.dn";
    public static final String USER_RESOLVER_LDAP_BIND_PASSWORD = "lens.server.user.resolver.ldap.bind.password";
    public static final String USER_RESOLVER_LDAP_SEARCH_BASE = "lens.server.user.resolver.ldap.search.base";
    public static final String USER_RESOLVER_LDAP_SEARCH_FILTER = "lens.server.user.resolver.ldap.search.filter";
    public static final String STORAGE_COST = "lens.metastore.table.storage.cost";
    public static final String NATIVE_DB_NAME = "lens.metastore.native.db.name";
    public static final String NATIVE_TABLE_NAME = "lens.metastore.native.table.name";
    public static final String ENABLE_CONSOLE_METRICS = "lens.server.enable.console.metrics";
    public static final String ENABLE_GANGLIA_METRICS = "lens.server.enable.ganglia.metrics";
    public static final String GANGLIA_SERVERNAME = "lens.server.metrics.ganglia.host";
    public static final String GANGLIA_PORT = "lens.server.metrics.ganglia.port";
    public static final String REPORTING_PERIOD = "lens.server.metrics.reporting.period";
    public static final String SERVER_MODE = "lens.server.mode";
    public static final String DEFAULT_SERVER_MODE = "OPEN";
    public static final String SERVER_DOMAIN = "lens.server.domain";
    public static final String QUERY_PERSISTENT_RESULT_SET = "lens.query.enable.persistent.resultset";
    public static final boolean DEFAULT_PERSISTENT_RESULT_SET = false;
    public static final String RESULT_SET_PARENT_DIR = "lens.query.result.parent.dir";
    public static final String RESULT_SET_PARENT_DIR_DEFAULT = "/tmp/lensreports";
    public static final String QUERY_ADD_INSERT_OVEWRITE = "lens.query.add.insert.overwrite";
    public static final boolean DEFAULT_ADD_INSERT_OVEWRITE = true;
    public static final String QUERY_PERSISTENT_RESULT_INDRIVER = "lens.query.enable.persistent.resultset.indriver";
    public static final boolean DEFAULT_DRIVER_PERSISTENT_RESULT_SET = true;
    public static final String QUERY_HDFS_OUTPUT_PATH = "lens.query.hdfs.output.path";
    public static final String DEFAULT_HDFS_OUTPUT_PATH = "hdfsout";
    public static final String QUERY_OUTPUT_DIRECTORY_FORMAT = "lens.query.result.output.dir.format";
    public static final String QUERY_OUTPUT_SQL_FORMAT = "lens.query.result.output.sql.format";
    public static final String QUERY_OUTPUT_FORMATTER = "lens.query.output.formatter";
    public static final String DEFAULT_INMEMORY_OUTPUT_FORMATTER = "org.apache.lens.lib.query.FileSerdeFormatter";
    public static final String DEFAULT_PERSISTENT_OUTPUT_FORMATTER = "org.apache.lens.lib.query.FilePersistentFormatter";
    public static final String QUERY_OUTPUT_SERDE = "lens.query.result.output.serde";
    public static final String DEFAULT_OUTPUT_SERDE = "org.apache.lens.lib.query.CSVSerde";
    public static final String QUERY_OUTPUT_FILE_EXTN = "lens.query.output.file.extn";
    public static final String DEFAULT_OUTPUT_FILE_EXTN = ".csv";
    public static final String QUERY_OUTPUT_CHARSET_ENCODING = "lens.query.output.charset.encoding";
    public static final String DEFAULT_OUTPUT_CHARSET_ENCODING = "UTF-8";
    public static final String QUERY_OUTPUT_ENABLE_COMPRESSION = "lens.query.output.enable.compression";
    public static final boolean DEFAULT_OUTPUT_ENABLE_COMPRESSION = false;
    public static final String QUERY_OUTPUT_COMPRESSION_CODEC = "lens.query.output.compression.codec";
    public static final String DEFAULT_OUTPUT_COMPRESSION_CODEC = "org.apache.hadoop.io.compress.GzipCodec";
    public static final String QUERY_OUTPUT_WRITE_HEADER = "lens.query.output.write.header";
    public static final boolean DEFAULT_OUTPUT_WRITE_HEADER = false;
    public static final String QUERY_OUTPUT_HEADER = "lens.query.output.header";
    public static final String QUERY_OUTPUT_WRITE_FOOTER = "lens.query.output.write.footer";
    public static final boolean DEFAULT_OUTPUT_WRITE_FOOTER = false;
    public static final String QUERY_OUTPUT_FOOTER = "lens.query.output.footer";
    public static final String RESULT_FORMAT_SIZE_THRESHOLD = "lens.query.result.size.format.threshold";
    public static final long DEFAULT_RESULT_FORMAT_SIZE_THRESHOLD = 0x280000000L;
    public static final String RESULT_SPLIT_INTO_MULTIPLE = "lens.query.result.split.multiple";
    public static final boolean DEFAULT_RESULT_SPLIT_INTO_MULTIPLE = false;
    public static final String RESULT_SPLIT_MULTIPLE_MAX_ROWS = "lens.query.result.split.multiple.maxrows";
    public static final long DEFAULT_RESULT_SPLIT_MULTIPLE_MAX_ROWS = 100000L;
    public static final String RESULT_FS_READ_URL = "lens.query.result.fs.read.url";
    public static final String AUX_JARS = "lens.session.aux.jars";
    public static final String STATS_STORE_CLASS = "lens.server.statistics.store.class";
    public static final String STATISTICS_WAREHOUSE_KEY = "lens.server.statistics.warehouse.dir";
    public static final String DEFAULT_STATISTICS_WAREHOUSE = "file:///tmp/lens/statistics/warehouse";
    public static final String STATISTICS_DATABASE_KEY = "lens.server.statistics.db";
    public static final String DEFAULT_STATISTICS_DATABASE = "lensstats";
    public static final String STATS_ROLLUP_SCAN_RATE = "lens.server.statistics.log.rollover.interval";
    public static final long DEFAULT_STATS_ROLLUP_SCAN_RATE = 3600000L;
    public static final String MAX_NUMBER_OF_FINISHED_QUERY = "lens.server.max.finished.queries";
    public static final int DEFAULT_FINISHED_QUERIES = 100;
    public static final String SERVER_DB_DRIVER_NAME = "lens.server.db.driver.name";
    public static final String DEFAULT_SERVER_DB_DRIVER_NAME = "org.hsqldb.jdbcDriver";
    public static final String SERVER_DB_JDBC_URL = "lens.server.db.jdbc.url";
    public static final String DEFAULT_SERVER_DB_JDBC_URL = "jdbc:hsqldb:/tmp/lensserver/queries.db";
    public static final String SERVER_DB_JDBC_USER = "lens.server.db.jdbc.user";
    public static final String DEFAULT_SERVER_DB_USER = "SA";
    public static final String SERVER_DB_JDBC_PASS = "lens.server.db.jdbc.pass";
    public static final String DEFAULT_SERVER_DB_PASS = "";
    public static final String SERVICE_PROVIDER_FACTORY = "lens.server.service.provider.factory";
    public static final String STATE_PERSIST_OUT_STREAM_BUFF_SIZE = "lens.server.state.persist.out.stream.buffer.size";
    public static final int DEFAULT_STATE_PERSIST_OUT_STREAM_BUFF_SIZE = 0x100000;

    private LensConfConstants() throws LensException {
        throw new LensException("Can't instantiate LensConfConstants");
    }

    public static String getServiceImplConfKey(String sName) {
        return SERVER_PFX + sName + SERVICE_IMPL_SFX;
    }

    public static String getWSResourceImplConfKey(String rName) {
        return SERVER_PFX + rName + WS_RESOURCE_IMPL_SFX;
    }

    public static String getWSFeatureImplConfKey(String featureName) {
        return SERVER_PFX + featureName + WS_FEATURE_IMPL_SFX;
    }

    public static String getWSListenerImplConfKey(String listenerName) {
        return SERVER_PFX + listenerName + WS_LISTENER_IMPL_SFX;
    }

    public static String getWSFilterImplConfKey(String filterName) {
        return SERVER_PFX + filterName + WS_FILTER_IMPL_SFX;
    }
}

