/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.driver;

import java.util.Collections;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.server.api.driver.DriverQueryPlan;
import org.apache.lens.server.api.driver.DriverSelector;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.query.AbstractQueryContext;
import org.apache.log4j.Logger;

public class MinQueryCostSelector
implements DriverSelector {
    public static final Logger LOG = Logger.getLogger(MinQueryCostSelector.class);

    @Override
    public LensDriver select(final AbstractQueryContext ctx, Configuration conf) {
        return Collections.min(ctx.getDriverContext().getDrivers(), new Comparator<LensDriver>(){

            @Override
            public int compare(LensDriver d1, LensDriver d2) {
                return MinQueryCostSelector.this.comparePlans(ctx.getDriverContext().getDriverQueryPlan(d1), ctx.getDriverContext().getDriverQueryPlan(d2));
            }
        });
    }

    int comparePlans(DriverQueryPlan c1, DriverQueryPlan c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null && c2 != null) {
            return 1;
        }
        if (c1 != null && c2 == null) {
            return -1;
        }
        return c1.getCost().compareTo(c2.getCost());
    }
}

