/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.events;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lens.api.LensException;
import org.apache.lens.server.api.events.LensEvent;
import org.apache.lens.server.api.events.LensEventListener;

public abstract class AsyncEventListener<T extends LensEvent>
implements LensEventListener<T> {
    protected final ThreadPoolExecutor processor;
    protected final BlockingQueue<Runnable> eventQueue;

    public AsyncEventListener() {
        this(1);
    }

    public AsyncEventListener(int poolSize) {
        this(poolSize, -1, 10L, true);
    }

    public AsyncEventListener(int poolSize, int maxQueueSize, long timeOutSeconds, final boolean isDaemon) {
        this.eventQueue = maxQueueSize <= 0 ? new LinkedBlockingQueue<Runnable>() : new ArrayBlockingQueue<Runnable>(maxQueueSize);
        this.processor = new ThreadPoolExecutor(poolSize, poolSize, timeOutSeconds, TimeUnit.SECONDS, this.eventQueue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread th = new Thread(runnable);
                th.setName("event_processor_thread");
                th.setDaemon(isDaemon);
                return th;
            }
        });
        this.processor.allowCoreThreadTimeOut(true);
    }

    @Override
    public void onEvent(T event) throws LensException {
        try {
            this.processor.execute(new Runnable((LensEvent)event){
                final /* synthetic */ LensEvent val$event;
                {
                    this.val$event = lensEvent;
                }

                @Override
                public void run() {
                    AsyncEventListener.this.process(this.val$event);
                }
            });
        }
        catch (RejectedExecutionException rejected) {
            throw new LensException((Throwable)rejected);
        }
    }

    public abstract void process(T var1);

    public void stop() {
        this.processor.shutdownNow();
    }

    public BlockingQueue<Runnable> getEventQueue() {
        return this.eventQueue;
    }
}

