/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.priority;

import java.util.TreeMap;

public abstract class RangeConf<K extends Comparable<K>, V> {
    TreeMap<K, V> map = new TreeMap();
    V floor;

    RangeConf(String confValue) {
        if (confValue == null || confValue.isEmpty()) {
            confValue = this.getDefaultConf();
        }
        String[] split = confValue.split("\\s*,\\s*");
        assert (split.length % 2 == 1);
        this.floor = this.parseValue(split[0]);
        for (int i = 1; i < split.length; i += 2) {
            this.map.put(this.parseKey(split[i]), this.parseValue(split[i + 1]));
        }
    }

    protected abstract K parseKey(String var1);

    protected abstract V parseValue(String var1);

    protected abstract String getDefaultConf();

    public V get(K key) {
        return this.map.floorEntry(key) == null ? this.floor : this.map.floorEntry(key).getValue();
    }

    public String toString() {
        return "lower value: " + this.floor + ", map: " + this.map;
    }
}

