/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.query;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.query.QueryContext;

public class FinishedLensQuery {
    private String handle;
    private String userQuery;
    private String submitter;
    private long submissionTime;
    private long startTime;
    private long endTime;
    private String result;
    private String status;
    private String metadata;
    private int rows;
    private String errorMessage;
    private long driverStartTime;
    private long driverEndTime;
    private String metadataClass;
    private String queryName;

    public FinishedLensQuery() {
    }

    public FinishedLensQuery(QueryContext ctx) {
        this.handle = ctx.getQueryHandle().toString();
        this.userQuery = ctx.getUserQuery();
        this.submitter = ctx.getSubmittedUser();
        this.submissionTime = ctx.getSubmissionTime();
        this.startTime = ctx.getLaunchTime();
        this.endTime = ctx.getEndTime();
        this.result = ctx.getResultSetPath();
        this.status = ctx.getStatus().getStatus().name();
        this.errorMessage = ctx.getStatus().getErrorMessage();
        this.driverStartTime = ctx.getDriverStatus().getDriverStartTime();
        this.driverEndTime = ctx.getDriverStatus().getDriverFinishTime();
        if (ctx.getQueryName() != null) {
            this.queryName = ctx.getQueryName().toLowerCase();
        }
    }

    public QueryContext toQueryContext(Configuration conf, Collection<LensDriver> drivers) throws LensException {
        QueryContext qctx = new QueryContext(this.userQuery, this.submitter, new LensConf(), conf, drivers, null, this.submissionTime);
        qctx.setQueryHandle(QueryHandle.fromString((String)this.handle));
        qctx.setEndTime(this.getEndTime());
        qctx.setStatusSkippingTransitionTest(new QueryStatus(0.0, QueryStatus.Status.valueOf((String)this.getStatus()), this.getErrorMessage() == null ? "" : this.getErrorMessage(), this.getResult() != null, null, null));
        qctx.getDriverStatus().setDriverStartTime(this.getDriverStartTime());
        qctx.getDriverStatus().setDriverFinishTime(this.getDriverEndTime());
        qctx.setResultSetPath(this.getResult());
        qctx.setQueryName(this.getQueryName());
        return qctx;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinishedLensQuery)) {
            return false;
        }
        FinishedLensQuery other = (FinishedLensQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$handle = this.getHandle();
        String other$handle = other.getHandle();
        if (this$handle == null ? other$handle != null : !this$handle.equals(other$handle)) {
            return false;
        }
        String this$userQuery = this.getUserQuery();
        String other$userQuery = other.getUserQuery();
        if (this$userQuery == null ? other$userQuery != null : !this$userQuery.equals(other$userQuery)) {
            return false;
        }
        String this$submitter = this.getSubmitter();
        String other$submitter = other.getSubmitter();
        if (this$submitter == null ? other$submitter != null : !this$submitter.equals(other$submitter)) {
            return false;
        }
        if (this.getSubmissionTime() != other.getSubmissionTime()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        if (this.getDriverStartTime() != other.getDriverStartTime()) {
            return false;
        }
        if (this.getDriverEndTime() != other.getDriverEndTime()) {
            return false;
        }
        String this$metadataClass = this.getMetadataClass();
        String other$metadataClass = other.getMetadataClass();
        if (this$metadataClass == null ? other$metadataClass != null : !this$metadataClass.equals(other$metadataClass)) {
            return false;
        }
        String this$queryName = this.getQueryName();
        String other$queryName = other.getQueryName();
        return !(this$queryName == null ? other$queryName != null : !this$queryName.equals(other$queryName));
    }

    public boolean canEqual(Object other) {
        return other instanceof FinishedLensQuery;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        String $handle = this.getHandle();
        result = result * 277 + ($handle == null ? 0 : $handle.hashCode());
        String $userQuery = this.getUserQuery();
        result = result * 277 + ($userQuery == null ? 0 : $userQuery.hashCode());
        String $submitter = this.getSubmitter();
        result = result * 277 + ($submitter == null ? 0 : $submitter.hashCode());
        long $submissionTime = this.getSubmissionTime();
        result = result * 277 + (int)($submissionTime >>> 32 ^ $submissionTime);
        long $startTime = this.getStartTime();
        result = result * 277 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 277 + (int)($endTime >>> 32 ^ $endTime);
        String $result = this.getResult();
        result = result * 277 + ($result == null ? 0 : $result.hashCode());
        String $status = this.getStatus();
        result = result * 277 + ($status == null ? 0 : $status.hashCode());
        String $metadata = this.getMetadata();
        result = result * 277 + ($metadata == null ? 0 : $metadata.hashCode());
        result = result * 277 + this.getRows();
        String $errorMessage = this.getErrorMessage();
        result = result * 277 + ($errorMessage == null ? 0 : $errorMessage.hashCode());
        long $driverStartTime = this.getDriverStartTime();
        result = result * 277 + (int)($driverStartTime >>> 32 ^ $driverStartTime);
        long $driverEndTime = this.getDriverEndTime();
        result = result * 277 + (int)($driverEndTime >>> 32 ^ $driverEndTime);
        String $metadataClass = this.getMetadataClass();
        result = result * 277 + ($metadataClass == null ? 0 : $metadataClass.hashCode());
        String $queryName = this.getQueryName();
        result = result * 277 + ($queryName == null ? 0 : $queryName.hashCode());
        return result;
    }

    public String toString() {
        return "FinishedLensQuery(handle=" + this.getHandle() + ", userQuery=" + this.getUserQuery() + ", submitter=" + this.getSubmitter() + ", submissionTime=" + this.getSubmissionTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", result=" + this.getResult() + ", status=" + this.getStatus() + ", metadata=" + this.getMetadata() + ", rows=" + this.getRows() + ", errorMessage=" + this.getErrorMessage() + ", driverStartTime=" + this.getDriverStartTime() + ", driverEndTime=" + this.getDriverEndTime() + ", metadataClass=" + this.getMetadataClass() + ", queryName=" + this.getQueryName() + ")";
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public void setUserQuery(String userQuery) {
        this.userQuery = userQuery;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(long submissionTime) {
        this.submissionTime = submissionTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getDriverStartTime() {
        return this.driverStartTime;
    }

    public void setDriverStartTime(long driverStartTime) {
        this.driverStartTime = driverStartTime;
    }

    public long getDriverEndTime() {
        return this.driverEndTime;
    }

    public void setDriverEndTime(long driverEndTime) {
        this.driverEndTime = driverEndTime;
    }

    public String getMetadataClass() {
        return this.metadataClass;
    }

    public void setMetadataClass(String metadataClass) {
        this.metadataClass = metadataClass;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }
}

