/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.query;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.query.LensPreparedQuery;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.query.AbstractQueryContext;

public class PreparedQueryContext
extends AbstractQueryContext
implements Delayed {
    private static final long serialVersionUID = 1L;
    private final QueryPrepareHandle prepareHandle;
    private final Date preparedTime = new Date();
    private final String preparedUser;
    private String queryName;
    private static long millisInWeek = 604800000L;

    public PreparedQueryContext(String query, String user, Configuration conf, Collection<LensDriver> drivers) {
        this(query, user, conf, new LensConf(), drivers);
    }

    public PreparedQueryContext(String query, String user, Configuration conf, LensConf qconf, Collection<LensDriver> drivers) {
        super(query, user, qconf, conf, drivers);
        this.preparedUser = user;
        this.prepareHandle = new QueryPrepareHandle(UUID.randomUUID());
        this.conf = conf;
        this.lensConf = qconf;
    }

    @Override
    public int compareTo(Delayed o) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public long getDelay(TimeUnit units) {
        if (this.preparedTime != null) {
            Date now = new Date();
            long elapsedMills = now.getTime() - this.preparedTime.getTime();
            long delayMillis = millisInWeek - elapsedMills;
            return units.convert(delayMillis, TimeUnit.MILLISECONDS);
        }
        return Integer.MAX_VALUE;
    }

    public void updateConf(Map<String, String> confoverlay) {
        this.lensConf.getProperties().putAll(confoverlay);
        for (Map.Entry<String, String> prop : confoverlay.entrySet()) {
            this.conf.set(prop.getKey(), prop.getValue());
        }
    }

    public LensPreparedQuery toPreparedQuery() {
        return new LensPreparedQuery(this.prepareHandle, this.userQuery, this.preparedTime, this.preparedUser, this.getDriverContext().getSelectedDriver() != null ? this.getDriverContext().getSelectedDriver().getClass().getCanonicalName() : null, this.getDriverContext().getSelectedDriverQuery(), this.lensConf);
    }

    public QueryPrepareHandle getPrepareHandle() {
        return this.prepareHandle;
    }

    public Date getPreparedTime() {
        return this.preparedTime;
    }

    public String getPreparedUser() {
        return this.preparedUser;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }
}

