/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.query;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.Priority;
import org.apache.lens.api.query.LensQuery;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.server.api.driver.DriverQueryStatus;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.query.AbstractQueryContext;
import org.apache.lens.server.api.query.PreparedQueryContext;
import org.apache.lens.server.api.query.QueryOutputFormatter;

public class QueryContext
extends AbstractQueryContext
implements Comparable<QueryContext> {
    private static final long serialVersionUID = 1L;
    private QueryHandle queryHandle;
    private Priority priority;
    private final boolean isPersistent;
    private boolean isDriverPersistent;
    private QueryStatus status;
    private String resultSetPath;
    private String hdfsoutPath;
    private final long submissionTime;
    private long launchTime;
    private long endTime;
    private long closedTime;
    private String driverOpHandle;
    final DriverQueryStatus driverStatus;
    private transient QueryOutputFormatter queryOutputFormatter;
    private boolean finishedQueryPersisted = false;
    private String queryName;

    public QueryContext(String query, String user, LensConf qconf, Configuration conf, Collection<LensDriver> drivers) {
        this(query, user, qconf, conf, drivers, null);
    }

    public QueryContext(PreparedQueryContext prepared, String user, LensConf qconf, Configuration conf) {
        this(prepared.getUserQuery(), user, qconf, QueryContext.mergeConf(prepared.getConf(), conf), prepared.getDriverContext().getDriverQueryContextMap().keySet(), prepared.getDriverContext().getSelectedDriver());
        this.setDriverContext(prepared.getDriverContext());
        this.setSelectedDriverQuery(prepared.getSelectedDriverQuery());
    }

    private QueryContext(String userQuery, String user, LensConf qconf, Configuration conf, Collection<LensDriver> drivers, LensDriver selectedDriver) {
        this(userQuery, user, qconf, conf, drivers, selectedDriver, System.currentTimeMillis());
    }

    QueryContext(String userQuery, String user, LensConf qconf, Configuration conf, Collection<LensDriver> drivers, LensDriver selectedDriver, long submissionTime) {
        super(userQuery, user, qconf, conf, drivers);
        this.submissionTime = submissionTime;
        this.queryHandle = new QueryHandle(UUID.randomUUID());
        this.status = new QueryStatus(0.0, QueryStatus.Status.NEW, "Query just got created", false, null, null);
        this.priority = Priority.NORMAL;
        this.lensConf = qconf;
        this.conf = conf;
        this.isPersistent = conf.getBoolean("lens.query.enable.persistent.resultset", false);
        this.isDriverPersistent = conf.getBoolean("lens.query.enable.persistent.resultset.indriver", true);
        this.userQuery = userQuery;
        if (selectedDriver != null) {
            this.setSelectedDriver(selectedDriver);
        }
        this.lensConf = qconf;
        this.driverStatus = new DriverQueryStatus();
    }

    public static QueryContext createContextWithSingleDriver(String query, String user, LensConf qconf, Configuration conf, LensDriver driver, String lensSessionPublicId) {
        QueryContext ctx = new QueryContext(query, user, qconf, conf, Lists.newArrayList((Object[])new LensDriver[]{driver}), driver);
        ctx.setLensSessionIdentifier(lensSessionPublicId);
        return ctx;
    }

    private static Configuration mergeConf(Configuration prepared, Configuration current) {
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : prepared) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : current) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return conf;
    }

    @Override
    public int compareTo(QueryContext other) {
        int pcomp = this.priority.compareTo((Enum)other.priority);
        if (pcomp == 0) {
            return (int)(this.submissionTime - other.submissionTime);
        }
        return pcomp;
    }

    public void updateConf(Map<String, String> confoverlay) {
        this.lensConf.getProperties().putAll(confoverlay);
        for (Map.Entry<String, String> prop : confoverlay.entrySet()) {
            this.conf.set(prop.getKey(), prop.getValue());
        }
    }

    public String getResultSetParentDir() {
        return this.conf.get("lens.query.result.parent.dir", "/tmp/lensreports");
    }

    public Path getHDFSResultDir() {
        return new Path(new Path(this.getResultSetParentDir(), this.conf.get("lens.query.hdfs.output.path", "hdfsout")), this.queryHandle.toString());
    }

    public LensQuery toLensQuery() {
        return new LensQuery(this.queryHandle, this.userQuery, super.getSubmittedUser(), this.priority, this.isPersistent, this.getSelectedDriver() != null ? this.getSelectedDriver().getClass().getCanonicalName() : null, this.getSelectedDriverQuery(), this.status, this.resultSetPath, this.driverOpHandle, this.lensConf, this.submissionTime, this.launchTime, this.driverStatus.getDriverStartTime().longValue(), this.driverStatus.getDriverFinishTime().longValue(), this.endTime, this.closedTime, this.queryName);
    }

    public boolean isResultAvailableInDriver() {
        return this.isDriverPersistent() || this.driverStatus.isResultSetAvailable();
    }

    public void unSetDriverPersistent() {
        this.isDriverPersistent = false;
    }

    void setStatusSkippingTransitionTest(QueryStatus newStatus) throws LensException {
        this.status = newStatus;
    }

    public synchronized void setStatus(QueryStatus newStatus) throws LensException {
        if (!this.status.isValidateTransition(newStatus.getStatus())) {
            throw new LensException("Invalid state transition:[" + this.status.getStatus() + "->" + newStatus.getStatus() + "]");
        }
        this.status = newStatus;
    }

    public String getResultHeader() {
        return this.getConf().get("lens.query.output.header");
    }

    public String getResultFooter() {
        return this.getConf().get("lens.query.output.footer");
    }

    public String getResultEncoding() {
        return this.conf.get("lens.query.output.charset.encoding", "UTF-8");
    }

    public String getOuptutFileExtn() {
        return this.conf.get("lens.query.output.file.extn", ".csv");
    }

    public boolean getCompressOutput() {
        return this.conf.getBoolean("lens.query.output.enable.compression", false);
    }

    public long getMaxResultSplitRows() {
        return this.conf.getLong("lens.query.result.split.multiple.maxrows", 100000L);
    }

    public boolean splitResultIntoMultipleFiles() {
        return this.conf.getBoolean("lens.query.result.split.multiple", false);
    }

    public String getClusterUser() {
        return this.conf.get("lens.session.cluster.user", this.getSubmittedUser());
    }

    public QueryHandle getQueryHandle() {
        return this.queryHandle;
    }

    public void setQueryHandle(QueryHandle queryHandle) {
        this.queryHandle = queryHandle;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isDriverPersistent() {
        return this.isDriverPersistent;
    }

    public QueryStatus getStatus() {
        return this.status;
    }

    public String getResultSetPath() {
        return this.resultSetPath;
    }

    public void setResultSetPath(String resultSetPath) {
        this.resultSetPath = resultSetPath;
    }

    public String getHdfsoutPath() {
        return this.hdfsoutPath;
    }

    public void setHdfsoutPath(String hdfsoutPath) {
        this.hdfsoutPath = hdfsoutPath;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(long launchTime) {
        this.launchTime = launchTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getClosedTime() {
        return this.closedTime;
    }

    public void setClosedTime(long closedTime) {
        this.closedTime = closedTime;
    }

    public String getDriverOpHandle() {
        return this.driverOpHandle;
    }

    public void setDriverOpHandle(String driverOpHandle) {
        this.driverOpHandle = driverOpHandle;
    }

    public DriverQueryStatus getDriverStatus() {
        return this.driverStatus;
    }

    public QueryOutputFormatter getQueryOutputFormatter() {
        return this.queryOutputFormatter;
    }

    public void setQueryOutputFormatter(QueryOutputFormatter queryOutputFormatter) {
        this.queryOutputFormatter = queryOutputFormatter;
    }

    public boolean isFinishedQueryPersisted() {
        return this.finishedQueryPersisted;
    }

    public void setFinishedQueryPersisted(boolean finishedQueryPersisted) {
        this.finishedQueryPersisted = finishedQueryPersisted;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }
}

