/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.query;

import java.util.EnumSet;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.server.api.query.StatusChange;

public class QueryEnded
extends StatusChange {
    private final String user;
    private final String cause;
    public static final EnumSet<QueryStatus.Status> END_STATES = EnumSet.of(QueryStatus.Status.SUCCESSFUL, QueryStatus.Status.CANCELED, QueryStatus.Status.CLOSED, QueryStatus.Status.FAILED);

    public QueryEnded(long eventTime, QueryStatus.Status prev, QueryStatus.Status current, QueryHandle handle, String user, String cause) {
        super(eventTime, prev, current, handle);
        this.user = user;
        this.cause = cause;
        if (!END_STATES.contains(current)) {
            throw new IllegalStateException("Not a valid end state: " + current + " query: " + handle);
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getCause() {
        return this.cause;
    }
}

