/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.query;

import java.util.UUID;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.server.api.events.LensEvent;

public abstract class QueryEvent<T>
extends LensEvent {
    protected final T previousValue;
    protected final T currentValue;
    protected final QueryHandle queryHandle;
    protected final UUID id = UUID.randomUUID();

    public QueryEvent(long eventTime, T prev, T current, QueryHandle handle) {
        super(eventTime);
        this.previousValue = prev;
        this.currentValue = current;
        this.queryHandle = handle;
    }

    @Override
    public String getEventId() {
        return this.id.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("QueryEvent: ").append(this.getClass().getSimpleName()).append(":{id: ").append(this.id).append(", query:").append(this.getQueryHandle()).append(", change:[").append(this.previousValue).append(" -> ").append(this.currentValue).append("]}");
        return buf.toString();
    }

    public T getPreviousValue() {
        return this.previousValue;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public QueryHandle getQueryHandle() {
        return this.queryHandle;
    }
}

