/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.Service;
import org.apache.lens.api.LensException;
import org.apache.lens.server.api.events.LensEvent;
import org.apache.lens.server.api.events.LensEventListener;
import org.apache.lens.server.api.events.LensEventService;

public class EventServiceImpl
extends AbstractService
implements LensEventService {
    public static final Log LOG = LogFactory.getLog(EventServiceImpl.class);
    private final Map<Class<? extends LensEvent>, List<LensEventListener>> eventListeners = new HashMap<Class<? extends LensEvent>, List<LensEventListener>>();
    private ExecutorService eventHandlerPool;

    public EventServiceImpl(String name) {
        super(name);
    }

    public synchronized void init(HiveConf hiveConf) {
        int numProcs = Runtime.getRuntime().availableProcessors();
        this.eventHandlerPool = Executors.newFixedThreadPool(hiveConf.getInt("lens.server.event.service.thread.pool.size", numProcs));
        super.init(hiveConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LensEventListener listener) {
        Map<Class<? extends LensEvent>, List<LensEventListener>> map = this.eventListeners;
        synchronized (map) {
            for (List<LensEventListener> listeners : this.eventListeners.values()) {
                if (!listeners.remove(listener)) continue;
                LOG.info((Object)("Removed listener " + listener));
            }
        }
    }

    private void handleEvent(List<LensEventListener> listeners, LensEvent evt) {
        if (listeners != null && !listeners.isEmpty()) {
            for (LensEventListener listener : listeners) {
                try {
                    listener.onEvent(evt);
                }
                catch (Exception exc) {
                    LOG.error((Object)("Error in handling event" + evt.getEventId() + " for listener " + listener), (Throwable)exc);
                }
            }
        }
    }

    public void notifyEvent(LensEvent evt) throws LensException {
        if (this.getServiceState() != Service.STATE.STARTED) {
            throw new LensException("Event service is not in STARTED state. Current state is " + this.getServiceState());
        }
        if (evt == null) {
            return;
        }
        this.eventHandlerPool.submit(new EventHandler(evt));
    }

    public <T extends LensEvent> Collection<LensEventListener> getListeners(Class<T> eventType) {
        return Collections.unmodifiableList(this.eventListeners.get(eventType));
    }

    public synchronized void start() {
        super.start();
    }

    public void stop() {
        List<Runnable> pending;
        if (this.eventHandlerPool != null && (pending = this.eventHandlerPool.shutdownNow()) != null && !pending.isEmpty()) {
            StringBuilder pendingMsg = new StringBuilder("Pending Events:");
            for (Runnable handler : pending) {
                if (!(handler instanceof EventHandler)) continue;
                pendingMsg.append(((EventHandler)handler).event.getEventId()).append(",");
            }
            LOG.info((Object)("Event listener service stopped while " + pending.size() + " events still pending"));
            LOG.info((Object)pendingMsg.toString());
        }
        LOG.info((Object)"Event service stopped");
        super.stop();
    }

    public Map<Class<? extends LensEvent>, List<LensEventListener>> getEventListeners() {
        return this.eventListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends LensEvent> void addListenerForType(LensEventListener<? super T> listener, Class<T> eventType) {
        Map<Class<? extends LensEvent>, List<LensEventListener>> map = this.eventListeners;
        synchronized (map) {
            List<LensEventListener> listeners = this.eventListeners.get(eventType);
            if (listeners == null) {
                listeners = new ArrayList<LensEventListener>();
                this.eventListeners.put(eventType, listeners);
            }
            listeners.add(listener);
        }
        LOG.info((Object)("Added listener " + listener + " for type:" + eventType.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends LensEvent> void removeListenerForType(LensEventListener<? super T> listener, Class<T> eventType) {
        Map<Class<? extends LensEvent>, List<LensEventListener>> map = this.eventListeners;
        synchronized (map) {
            List<LensEventListener> listeners = this.eventListeners.get(eventType);
            if (listeners != null && listeners.remove(listener)) {
                LOG.info((Object)("Removed listener " + listener));
            }
        }
    }

    private final class EventHandler
    implements Runnable {
        final LensEvent event;

        EventHandler(LensEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            Class<?> evtClass = this.event.getClass();
            EventServiceImpl.this.handleEvent((List)EventServiceImpl.this.eventListeners.get(evtClass), this.event);
            Class<?> superClass = evtClass.getSuperclass();
            while (LensEvent.class.isAssignableFrom(superClass)) {
                if (EventServiceImpl.this.eventListeners.containsKey(superClass)) {
                    EventServiceImpl.this.handleEvent((List)EventServiceImpl.this.eventListeners.get(superClass), this.event);
                }
                superClass = superClass.getSuperclass();
            }
        }
    }
}

