/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.server.LensServices;

@Path(value="/")
public class IndexResource {
    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return "Lens server is up!";
    }

    @GET
    @Path(value="/index")
    @Produces(value={"text/plain"})
    public String getIndexMessage() {
        return "Hello World! from lens";
    }

    @GET
    @Path(value="/admin/stack")
    @Produces(value={"text/plain"})
    public String getThreadDump() {
        ThreadGroup topThreadGroup = Thread.currentThread().getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        Thread[] threads = new Thread[topThreadGroup.activeCount()];
        int nr = topThreadGroup.enumerate(threads);
        StringBuilder builder = new StringBuilder();
        builder.append("Total number of threads:").append(nr).append("\n");
        for (int i = 0; i < nr; ++i) {
            builder.append(threads[i].getName()).append("\n\tState: ").append((Object)threads[i].getState()).append("\n");
            String stackTrace = StringUtils.join((Object[])threads[i].getStackTrace(), (String)"\n");
            builder.append(stackTrace);
            builder.append("\n----------------------\n\n");
        }
        return builder.toString();
    }

    @GET
    @Path(value="/admin/status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        return LensServices.get().getServiceState().toString();
    }
}

