/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.LensServerConf;
import org.apache.lens.server.api.LensConfConstants;

@ApplicationPath(value="/")
public class LensApplication
extends Application {
    public static final Log LOG = LogFactory.getLog(LensApplication.class);
    public static HiveConf conf = LensServerConf.get();

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        String[] resourceNames = conf.getStrings("lens.server.ws.resourcenames");
        String[] featureNames = conf.getStrings("lens.server.ws.featurenames");
        String[] listenerNames = conf.getStrings("lens.server.ws.listenernames");
        String[] filterNames = conf.getStrings("lens.server.ws.filternames");
        for (String rName : resourceNames) {
            Class wsResourceClass = conf.getClass(LensConfConstants.getWSResourceImplConfKey((String)rName), null);
            classes.add(wsResourceClass);
            LOG.info((Object)("Added resource " + wsResourceClass));
        }
        for (String fName : featureNames) {
            Class wsFeatureClass = conf.getClass(LensConfConstants.getWSFeatureImplConfKey((String)fName), null);
            classes.add(wsFeatureClass);
            LOG.info((Object)("Added feature " + wsFeatureClass));
        }
        for (String lName : listenerNames) {
            Class wsListenerClass = conf.getClass(LensConfConstants.getWSListenerImplConfKey((String)lName), null);
            classes.add(wsListenerClass);
            LOG.info((Object)("Added listener " + wsListenerClass));
        }
        for (String filterName : filterNames) {
            Class wsFilterClass = conf.getClass(LensConfConstants.getWSFilterImplConfKey((String)filterName), null);
            classes.add(wsFilterClass);
            LOG.info((Object)("Added filter " + wsFilterClass));
        }
        return classes;
    }
}

