/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import org.apache.lens.server.LensRequestListener;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.log4j.Logger;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class LensApplicationListener
implements ApplicationEventListener {
    public static final Logger LOG = Logger.getLogger(LensApplicationListener.class);
    private LensRequestListener reqListener = new LensRequestListener();

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        MetricsService metricsSvc;
        if (RequestEvent.Type.START == requestEvent.getType() && (metricsSvc = (MetricsService)LensServices.get().getService("metrics")) != null) {
            metricsSvc.incrCounter(LensRequestListener.class, "http-requests-started");
        }
        return this.reqListener;
    }

    public void onEvent(ApplicationEvent event) {
        switch (event.getType()) {
            case INITIALIZATION_FINISHED: {
                LOG.info((Object)("Application " + event.getResourceConfig().getApplicationName() + " was initialized."));
                break;
            }
            case DESTROY_FINISHED: {
                LOG.info((Object)("Application " + event.getResourceConfig().getApplicationName() + " was destroyed"));
                break;
            }
        }
    }
}

