/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import com.codahale.metrics.servlets.AdminServlet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.LensApplication;
import org.apache.lens.server.LensServerConf;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.MetricsServiceImpl;
import org.apache.lens.server.ui.UIApp;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LensServer {
    public static final Log LOG = LogFactory.getLog(LensServer.class);
    private static final String SEP_LINE = "\n###############################################################\n";
    final HttpServer server;
    final HttpServer uiServer;
    final HiveConf conf;
    volatile boolean canRun = true;

    private LensServer(HiveConf conf) throws IOException {
        this.conf = conf;
        this.startServices(conf);
        String baseURI = conf.get("lens.server.base.url", "http://0.0.0.0:9999/lensapi");
        this.server = GrizzlyHttpServerFactory.createHttpServer((URI)UriBuilder.fromUri((String)baseURI).build(new Object[0]), (ResourceConfig)this.getApp(), (boolean)false);
        WebappContext adminCtx = new WebappContext("admin", "");
        adminCtx.setAttribute("com.codahale.metrics.servlets.MetricsServlet.registry", (Object)((MetricsServiceImpl)((Object)LensServices.get().getService("metrics"))).getMetricRegistry());
        adminCtx.setAttribute("com.codahale.metrics.servlets.HealthCheckServlet.registry", (Object)((MetricsServiceImpl)((Object)LensServices.get().getService("metrics"))).getHealthCheck());
        ServletRegistration sgMetrics = adminCtx.addServlet("admin", (Servlet)new AdminServlet());
        sgMetrics.addMapping(new String[]{"/admin/*"});
        adminCtx.deploy(this.server);
        String uiServerURI = conf.get("lens.server.ui.base.uri", "http://0.0.0.0:19999/");
        this.uiServer = GrizzlyHttpServerFactory.createHttpServer((URI)UriBuilder.fromUri((String)uiServerURI).build(new Object[0]), (ResourceConfig)this.getUIApp(), (boolean)false);
    }

    private ResourceConfig getApp() {
        ResourceConfig app = ResourceConfig.forApplicationClass(LensApplication.class);
        app.register((Object)new LoggingFilter(Logger.getLogger(LensServer.class.getName() + ".request"), true));
        app.setApplicationName("AllApps");
        return app;
    }

    private ResourceConfig getUIApp() {
        ResourceConfig uiApp = ResourceConfig.forApplicationClass(UIApp.class);
        uiApp.register((Object)new LoggingFilter(Logger.getLogger(LensServer.class.getName() + ".ui_request"), true));
        uiApp.setApplicationName("Lens UI");
        return uiApp;
    }

    public void startServices(HiveConf conf) {
        LensServices.get().init(conf);
        LensServices.get().start();
    }

    public synchronized void start() throws IOException {
        this.server.start();
        this.uiServer.start();
    }

    public synchronized void stop() {
        this.server.shutdownNow();
        this.uiServer.shutdownNow();
        LensServices.get().stop();
        LensServer.printShutdownMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join() {
        while (this.canRun) {
            LensServer lensServer = this;
            synchronized (lensServer) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Received an interrupt in the main loop", (Throwable)e);
                }
            }
        }
        LOG.info((Object)"Exiting main run loop...");
    }

    public static void main(String[] args) throws Exception {
        LensServer.printStartupMessage();
        try {
            LensServer thisServer = new LensServer(LensServerConf.get());
            LensServer.registerShutdownHook(thisServer);
            LensServer.registerDefaultExceptionHandler();
            thisServer.start();
            thisServer.join();
        }
        catch (Exception exc) {
            LOG.fatal((Object)"Error while creating Lens server", (Throwable)exc);
            try {
                LensServices.get().stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Error stopping services", (Throwable)e);
            }
        }
    }

    private static void printStartupMessage() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SEP_LINE);
        buffer.append("                    Lens Server (STARTUP)");
        Properties buildProperties = new Properties();
        InputStream buildPropertiesResource = LensServer.class.getResourceAsStream("/lens-build-info.properties");
        if (buildPropertiesResource != null) {
            try {
                buildProperties.load(buildPropertiesResource);
                for (Map.Entry<Object, Object> entry : buildProperties.entrySet()) {
                    buffer.append('\n').append('\t').append(entry.getKey()).append(":\t").append(entry.getValue());
                }
            }
            catch (Throwable e) {
                buffer.append("*** Unable to get build info ***");
            }
        } else {
            buffer.append("*** Unable to get build info ***");
        }
        buffer.append(SEP_LINE);
        LOG.info((Object)buffer.toString());
    }

    private static void printShutdownMessage() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SEP_LINE);
        buffer.append("                    Lens Server (SHUTDOWN)");
        buffer.append(SEP_LINE);
        LOG.info((Object)buffer.toString());
    }

    private static void registerShutdownHook(final LensServer thisServer) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Thread.currentThread().setName("Shutdown");
                LOG.info((Object)"Server has been requested to be stopped.");
                thisServer.canRun = false;
                thisServer.stop();
            }
        });
    }

    private static void registerDefaultExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.fatal((Object)("Uncaught exception in Thread " + t), e);
            }
        });
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

